/*
 * Decompiled with CFR 0.152.
 */
package dev.iurysouza.modulegraph;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u001e\u0010\u0012\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Ldev/iurysouza/modulegraph/ReadmeWriter;", "", "<init>", "()V", "appendOrOverwriteGraph", "", "mermaidGraph", "", "readMeSection", "readmeFile", "Ljava/io/File;", "logger", "Lorg/gradle/api/logging/Logger;", "findPredefinedSection", "", "readmeLines", "", "section", "findNextSectionStart", "startIndex", "modulegraph"})
@SourceDebugExtension(value={"SMAP\nReadmeWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadmeWriter.kt\ndev/iurysouza/modulegraph/ReadmeWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n350#2,7:47\n350#2,7:54\n*S KotlinDebug\n*F\n+ 1 ReadmeWriter.kt\ndev/iurysouza/modulegraph/ReadmeWriter\n*L\n37#1:47,7\n41#1:54,7\n*E\n"})
public final class ReadmeWriter {
    @NotNull
    public static final ReadmeWriter INSTANCE = new ReadmeWriter();

    private ReadmeWriter() {
    }

    public final void appendOrOverwriteGraph(@NotNull String mermaidGraph, @NotNull String readMeSection, @NotNull File readmeFile, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)mermaidGraph, (String)"mermaidGraph");
        Intrinsics.checkNotNullParameter((Object)readMeSection, (String)"readMeSection");
        Intrinsics.checkNotNullParameter((Object)readmeFile, (String)"readmeFile");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        if (!readmeFile.exists()) {
            readmeFile.createNewFile();
            logger.warn(StringsKt.trimMargin$default((String)("\n                The specified README file was not found.\n                A new file has been created at: " + readmeFile.getPath() + "\n                "), null, (int)1, null));
        }
        List readmeLines = CollectionsKt.toMutableList((Collection)FilesKt.readLines$default((File)readmeFile, null, (int)1, null));
        int sectionStartIndex = this.findPredefinedSection(readmeLines, readMeSection);
        int sectionEndIndex = this.findNextSectionStart(readmeLines, sectionStartIndex);
        readmeLines.subList(sectionStartIndex + 1, sectionEndIndex).clear();
        if (sectionStartIndex == -1) {
            readmeLines.add(0, readMeSection + "\n\n" + mermaidGraph);
        } else {
            readmeLines.add(sectionStartIndex + 1, '\n' + mermaidGraph);
        }
        FilesKt.writeText$default((File)readmeFile, (String)CollectionsKt.joinToString$default((Iterable)readmeLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)2, null);
        logger.debug("Module graph added to " + readmeFile.getPath() + " under the " + readMeSection + " section");
    }

    private final int findPredefinedSection(List<String> readmeLines, String section) {
        int n;
        block2: {
            List<String> $this$indexOfFirst$iv = readmeLines;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<String> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                String item$iv;
                String it = item$iv = iterator.next();
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, (String)section, (boolean)false, (int)2, null)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    private final int findNextSectionStart(List<String> readmeLines, int startIndex) {
        int n;
        block2: {
            List $this$indexOfFirst$iv = CollectionsKt.drop((Iterable)readmeLines, (int)(startIndex + 1));
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                String it = (String)item$iv;
                boolean bl = false;
                if (StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        return it != -1 ? it + startIndex + 1 : readmeLines.size();
    }
}

