/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.engine.commandrunner;

import dev.hilla.engine.commandrunner.CommandRunner;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRunner
implements CommandRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenRunner.class);
    private final File projectDir;
    private final String[] args;

    public MavenRunner(File projectDir, String ... args) {
        this.projectDir = projectDir;
        this.args = args;
    }

    public static Optional<CommandRunner> forProject(File projectDir, String ... args) {
        if (new File(projectDir, "pom.xml").exists()) {
            return Optional.of(new MavenRunner(projectDir, args));
        }
        return Optional.empty();
    }

    @Override
    public String[] arguments() {
        return this.args;
    }

    @Override
    public String[] testArguments() {
        return new String[]{"-v"};
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public File currentDirectory() {
        return this.projectDir;
    }

    @Override
    public List<String> executables() {
        return IS_WINDOWS ? List.of(".\\mvnw.cmd", "mvn.cmd") : List.of("./mvnw", "mvn");
    }
}

