/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.ScaleGestureDetectorCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import com.android.volley.R;
import com.android.volley.error.VolleyError;
import com.android.volley.misc.Utils;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.ui.NetworkImageView;

public class PhotoView
extends NetworkImageView
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener,
ScaleGestureDetector.OnScaleGestureListener,
Utils.HorizontallyScrollable {
    private static final long ZOOM_ANIMATION_DURATION = 300L;
    private static final long ROTATE_ANIMATION_DURATION = 500L;
    private static final long SNAP_DURATION = 100L;
    private static final long SNAP_DELAY = 250L;
    private static final float DOUBLE_TAP_SCALE_FACTOR = 1.5f;
    private static final float SNAP_THRESHOLD = 20.0f;
    private static final float CROPPED_SIZE = 256.0f;
    private static int sTouchSlopSquare;
    private static boolean sInitialized;
    private static int sCropSize;
    private static Bitmap sVideoImage;
    private static Bitmap sVideoNotReadyImage;
    private static Paint sCropDimPaint;
    private static Paint sCropPaint;
    private Drawable mDrawable;
    private Matrix mDrawMatrix;
    private Matrix mMatrix = new Matrix();
    private Matrix mOriginalMatrix = new Matrix();
    private int mFixedHeight = -1;
    private boolean mHaveLayout;
    private boolean mFullScreen;
    private byte[] mVideoBlob;
    private boolean mVideoReady;
    private boolean mAllowCrop;
    private Rect mCropRect = new Rect();
    private int mCropSize;
    private float mMaxInitialScaleFactor = 2.0f;
    private GestureDetectorCompat mGestureDetector;
    private ScaleGestureDetector mScaleGetureDetector;
    private View.OnClickListener mExternalClickListener;
    private boolean mTransformsEnabled;
    private boolean mDoubleTapToZoomEnabled = true;
    private boolean mDoubleTapDebounce;
    private boolean mIsDoubleTouch;
    private ScaleRunnable mScaleRunnable;
    private float mMinScale;
    private float mMaxScale;
    private TranslateRunnable mTranslateRunnable;
    private SnapRunnable mSnapRunnable;
    private RotateRunnable mRotateRunnable;
    private float mRotation;
    private RectF mTempSrc = new RectF();
    private RectF mTempDst = new RectF();
    private RectF mTranslateRect = new RectF();
    private float[] mValues = new float[9];
    private boolean mDoubleTapOccurred;
    private float mDownFocusX;
    private float mDownFocusY;
    private boolean mQuickScaleEnabled;

    public PhotoView(Context context) {
        super(context);
        this.initialize();
    }

    public PhotoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
    }

    public PhotoView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mScaleGetureDetector == null || this.mGestureDetector == null) {
            return true;
        }
        this.mScaleGetureDetector.onTouchEvent(event);
        this.mGestureDetector.onTouchEvent(event);
        int action = event.getAction();
        switch (action) {
            case 1: 
            case 3: {
                if (this.mTranslateRunnable.mRunning) break;
                this.snap();
            }
        }
        return true;
    }

    public boolean onDoubleTap(MotionEvent e) {
        this.mDoubleTapOccurred = true;
        if (!this.mQuickScaleEnabled) {
            return this.scale(e);
        }
        return false;
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        int action = e.getAction();
        boolean handled = false;
        switch (action) {
            case 0: {
                if (!this.mQuickScaleEnabled) break;
                this.mDownFocusX = e.getX();
                this.mDownFocusY = e.getY();
                break;
            }
            case 1: {
                if (!this.mQuickScaleEnabled) break;
                handled = this.scale(e);
                break;
            }
            case 2: {
                int deltaY;
                int deltaX;
                int distance;
                if (!this.mQuickScaleEnabled || !this.mDoubleTapOccurred || (distance = (deltaX = (int)(e.getX() - this.mDownFocusX)) * deltaX + (deltaY = (int)(e.getY() - this.mDownFocusY)) * deltaY) <= sTouchSlopSquare) break;
                this.mDoubleTapOccurred = false;
            }
        }
        return handled;
    }

    private boolean scale(MotionEvent e) {
        boolean handled = false;
        if (this.mDoubleTapToZoomEnabled && this.mTransformsEnabled && this.mDoubleTapOccurred) {
            if (!this.mDoubleTapDebounce) {
                float currentScale = this.getScale();
                float targetScale = currentScale * 1.5f;
                targetScale = Math.max(this.mMinScale, targetScale);
                targetScale = Math.min(this.mMaxScale, targetScale);
                this.mScaleRunnable.start(currentScale, targetScale, e.getX(), e.getY());
                handled = true;
            }
            this.mDoubleTapDebounce = false;
        }
        this.mDoubleTapOccurred = false;
        return handled;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        if (this.mExternalClickListener != null && !this.mIsDoubleTouch) {
            this.mExternalClickListener.onClick((View)this);
        }
        this.mIsDoubleTouch = false;
        return true;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    public void onLongPress(MotionEvent e) {
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.mTransformsEnabled) {
            this.translate(-distanceX, -distanceY);
        }
        return true;
    }

    public boolean onDown(MotionEvent e) {
        if (this.mTransformsEnabled) {
            this.mTranslateRunnable.stop();
            this.mSnapRunnable.stop();
        }
        return true;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (this.mTransformsEnabled) {
            this.mTranslateRunnable.start(velocityX, velocityY);
        }
        return true;
    }

    public boolean onScale(ScaleGestureDetector detector) {
        if (this.mTransformsEnabled) {
            this.mIsDoubleTouch = false;
            float currentScale = this.getScale();
            float newScale = currentScale * detector.getScaleFactor();
            this.scale(newScale, detector.getFocusX(), detector.getFocusY());
        }
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        if (this.mTransformsEnabled) {
            this.mScaleRunnable.stop();
            this.mIsDoubleTouch = true;
        }
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        if (this.mTransformsEnabled && this.mIsDoubleTouch) {
            this.mDoubleTapDebounce = true;
            this.resetTransformations();
        }
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mExternalClickListener = listener;
    }

    @Override
    public boolean interceptMoveLeft(float origX, float origY) {
        if (!this.mTransformsEnabled) {
            return false;
        }
        if (this.mTranslateRunnable.mRunning) {
            return true;
        }
        this.mMatrix.getValues(this.mValues);
        this.mTranslateRect.set(this.mTempSrc);
        this.mMatrix.mapRect(this.mTranslateRect);
        float viewWidth = this.getWidth();
        float transX = this.mValues[2];
        float drawWidth = this.mTranslateRect.right - this.mTranslateRect.left;
        if (!this.mTransformsEnabled || drawWidth <= viewWidth) {
            return false;
        }
        if (transX == 0.0f) {
            return false;
        }
        if (viewWidth >= drawWidth + transX) {
            return true;
        }
        return true;
    }

    @Override
    public boolean interceptMoveRight(float origX, float origY) {
        if (!this.mTransformsEnabled) {
            return false;
        }
        if (this.mTranslateRunnable.mRunning) {
            return true;
        }
        this.mMatrix.getValues(this.mValues);
        this.mTranslateRect.set(this.mTempSrc);
        this.mMatrix.mapRect(this.mTranslateRect);
        float viewWidth = this.getWidth();
        float transX = this.mValues[2];
        float drawWidth = this.mTranslateRect.right - this.mTranslateRect.left;
        if (!this.mTransformsEnabled || drawWidth <= viewWidth) {
            return false;
        }
        if (transX == 0.0f) {
            return true;
        }
        return !(viewWidth >= drawWidth + transX);
    }

    public void clear() {
        this.mGestureDetector = null;
        this.mScaleGetureDetector = null;
        this.mDrawable = null;
        this.mScaleRunnable.stop();
        this.mScaleRunnable = null;
        this.mTranslateRunnable.stop();
        this.mTranslateRunnable = null;
        this.mSnapRunnable.stop();
        this.mSnapRunnable = null;
        this.mRotateRunnable.stop();
        this.mRotateRunnable = null;
        this.setOnClickListener(null);
        this.mExternalClickListener = null;
        this.mDoubleTapOccurred = false;
    }

    public void bindResource(int resourceId) {
        this.bindDrawable(this.getResources().getDrawable(resourceId));
    }

    public void bindDrawable(Drawable drawable) {
        boolean changed = false;
        if (drawable != null && drawable != this.mDrawable) {
            if (this.mDrawable != null) {
                this.mDrawable.setCallback(null);
            }
            this.mDrawable = drawable;
            this.mMinScale = 0.0f;
            this.mDrawable.setCallback((Drawable.Callback)this);
            changed = true;
        }
        this.configureBounds(changed);
        this.invalidate();
    }

    public void bindPhoto(Bitmap photoBitmap) {
        boolean changed;
        boolean currentDrawableIsBitmapDrawable = this.mDrawable instanceof BitmapDrawable;
        boolean bl = changed = !currentDrawableIsBitmapDrawable;
        if (this.mDrawable != null && currentDrawableIsBitmapDrawable) {
            Bitmap drawableBitmap = ((BitmapDrawable)this.mDrawable).getBitmap();
            if (photoBitmap == drawableBitmap) {
                return;
            }
            changed = photoBitmap != null && (this.mDrawable.getIntrinsicWidth() != photoBitmap.getWidth() || this.mDrawable.getIntrinsicHeight() != photoBitmap.getHeight());
            this.mMinScale = 0.0f;
            this.mDrawable = null;
        }
        if (this.mDrawable == null && photoBitmap != null) {
            this.mDrawable = new BitmapDrawable(this.getResources(), photoBitmap);
        }
        this.configureBounds(changed);
        this.invalidate();
    }

    public Bitmap getPhoto() {
        if (this.mDrawable != null && this.mDrawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)this.mDrawable).getBitmap();
        }
        return null;
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public byte[] getVideoData() {
        return this.mVideoBlob;
    }

    public boolean isVideo() {
        return this.mVideoBlob != null;
    }

    public boolean isVideoReady() {
        return this.mVideoBlob != null && this.mVideoReady;
    }

    public boolean isPhotoBound() {
        return this.mDrawable != null;
    }

    public void setFullScreen(boolean fullScreen, boolean animate) {
        if (fullScreen != this.mFullScreen) {
            this.mFullScreen = fullScreen;
            this.requestLayout();
            this.invalidate();
        }
    }

    public void enableAllowCrop(boolean allowCrop) {
        if (allowCrop && this.mHaveLayout) {
            throw new IllegalArgumentException("Cannot set crop after view has been laid out");
        }
        if (!allowCrop && this.mAllowCrop) {
            throw new IllegalArgumentException("Cannot unset crop mode");
        }
        this.mAllowCrop = allowCrop;
    }

    public Bitmap getCroppedPhoto() {
        if (!this.mAllowCrop) {
            return null;
        }
        Bitmap croppedBitmap = Bitmap.createBitmap((int)256, (int)256, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas croppedCanvas = new Canvas(croppedBitmap);
        int cropWidth = this.mCropRect.right - this.mCropRect.left;
        float scaleWidth = 256.0f / (float)cropWidth;
        float scaleHeight = 256.0f / (float)cropWidth;
        Matrix matrix = new Matrix(this.mDrawMatrix);
        matrix.postTranslate((float)(-this.mCropRect.left), (float)(-this.mCropRect.top));
        matrix.postScale(scaleWidth, scaleHeight);
        if (this.mDrawable != null) {
            croppedCanvas.concat(matrix);
            this.mDrawable.draw(croppedCanvas);
        }
        return croppedBitmap;
    }

    public void resetTransformations() {
        this.mMatrix.set(this.mOriginalMatrix);
        this.invalidate();
    }

    public void rotateClockwise() {
        this.rotate(90.0f, true);
    }

    public void rotateCounterClockwise() {
        this.rotate(-90.0f, true);
    }

    public void rotateTo(float degree) {
        this.rotate(degree % 360.0f, true);
    }

    public void rotateTo(float degree, boolean animate) {
        this.rotate(degree % 360.0f, animate);
    }

    public float getRotationDegree() {
        return this.mRotation % 360.0f;
    }

    public void setRotationDegree(float degree) {
        this.mRotation = degree % 360.0f;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawable != null) {
            int saveCount = canvas.getSaveCount();
            canvas.save();
            if (this.mDrawMatrix != null) {
                canvas.concat(this.mDrawMatrix);
            }
            this.mDrawable.draw(canvas);
            canvas.restoreToCount(saveCount);
            if (this.mVideoBlob != null) {
                Bitmap videoImage = this.mVideoReady ? sVideoImage : sVideoNotReadyImage;
                int drawLeft = (this.getWidth() - videoImage.getWidth()) / 2;
                int drawTop = (this.getHeight() - videoImage.getHeight()) / 2;
                canvas.drawBitmap(videoImage, (float)drawLeft, (float)drawTop, null);
            }
            this.mTranslateRect.set(this.mDrawable.getBounds());
            if (this.mDrawMatrix != null) {
                this.mDrawMatrix.mapRect(this.mTranslateRect);
            }
            if (this.mAllowCrop) {
                int previousSaveCount = canvas.getSaveCount();
                canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), sCropDimPaint);
                canvas.save();
                canvas.clipRect(this.mCropRect);
                if (this.mDrawMatrix != null) {
                    canvas.concat(this.mDrawMatrix);
                }
                this.mDrawable.draw(canvas);
                canvas.restoreToCount(previousSaveCount);
                canvas.drawRect(this.mCropRect, sCropPaint);
            }
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mHaveLayout = true;
        int layoutWidth = this.getWidth();
        int layoutHeight = this.getHeight();
        if (this.mAllowCrop) {
            this.mCropSize = Math.min(sCropSize, Math.min(layoutWidth, layoutHeight));
            int cropLeft = (layoutWidth - this.mCropSize) / 2;
            int cropTop = (layoutHeight - this.mCropSize) / 2;
            int cropRight = cropLeft + this.mCropSize;
            int cropBottom = cropTop + this.mCropSize;
            this.mCropRect.set(cropLeft, cropTop, cropRight, cropBottom);
        }
        this.configureBounds(changed);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mFixedHeight != -1) {
            super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)this.mFixedHeight, (int)Integer.MIN_VALUE));
            this.setMeasuredDimension(this.getMeasuredWidth(), this.mFixedHeight);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public boolean verifyDrawable(Drawable drawable) {
        return this.mDrawable == drawable || super.verifyDrawable(drawable);
    }

    public void invalidateDrawable(Drawable drawable) {
        if (this.mDrawable == drawable) {
            this.invalidate();
        } else {
            super.invalidateDrawable(drawable);
        }
    }

    public void setFixedHeight(int fixedHeight) {
        boolean adjustBounds = fixedHeight != this.mFixedHeight;
        this.mFixedHeight = fixedHeight;
        this.setMeasuredDimension(this.getMeasuredWidth(), this.mFixedHeight);
        if (adjustBounds) {
            this.configureBounds(true);
            this.requestLayout();
        }
    }

    public void enableImageTransforms(boolean enable) {
        this.mTransformsEnabled = enable;
        if (!this.mTransformsEnabled) {
            this.resetTransformations();
        }
    }

    public boolean isImageTransformsEnabled() {
        return this.mTransformsEnabled;
    }

    private void configureBounds(boolean changed) {
        if (this.mDrawable == null || !this.mHaveLayout) {
            return;
        }
        int dwidth = this.mDrawable.getIntrinsicWidth();
        int dheight = this.mDrawable.getIntrinsicHeight();
        int vwidth = this.getWidth();
        int vheight = this.getHeight();
        boolean fits = !(dwidth >= 0 && vwidth != dwidth || dheight >= 0 && vheight != dheight);
        this.mDrawable.setBounds(0, 0, dwidth, dheight);
        if (changed || this.mMinScale == 0.0f && this.mDrawable != null && this.mHaveLayout) {
            this.generateMatrix();
            this.generateScale();
        }
        this.mMatrix.postRotate(this.getRotationDegree(), (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        this.mDrawMatrix = fits || this.mMatrix.isIdentity() ? null : this.mMatrix;
    }

    private void generateMatrix() {
        boolean fits;
        int dwidth = this.mDrawable.getIntrinsicWidth();
        int dheight = this.mDrawable.getIntrinsicHeight();
        int vwidth = this.mAllowCrop ? sCropSize : this.getWidth();
        int vheight = this.mAllowCrop ? sCropSize : this.getHeight();
        boolean bl = fits = !(dwidth >= 0 && vwidth != dwidth || dheight >= 0 && vheight != dheight);
        if (fits && !this.mAllowCrop) {
            this.mMatrix.reset();
        } else {
            this.mTempSrc.set(0.0f, 0.0f, (float)dwidth, (float)dheight);
            if (this.mAllowCrop) {
                this.mTempDst.set(this.mCropRect);
            } else {
                this.mTempDst.set(0.0f, 0.0f, (float)vwidth, (float)vheight);
            }
            RectF scaledDestination = new RectF((float)(vwidth / 2) - (float)dwidth * this.mMaxInitialScaleFactor / 2.0f, (float)(vheight / 2) - (float)dheight * this.mMaxInitialScaleFactor / 2.0f, (float)(vwidth / 2) + (float)dwidth * this.mMaxInitialScaleFactor / 2.0f, (float)(vheight / 2) + (float)dheight * this.mMaxInitialScaleFactor / 2.0f);
            if (this.mTempDst.contains(scaledDestination)) {
                this.mMatrix.setRectToRect(this.mTempSrc, scaledDestination, Matrix.ScaleToFit.CENTER);
            } else {
                this.mMatrix.setRectToRect(this.mTempSrc, this.mTempDst, Matrix.ScaleToFit.CENTER);
            }
        }
        this.mOriginalMatrix.set(this.mMatrix);
    }

    private void generateScale() {
        int dwidth = this.mDrawable.getIntrinsicWidth();
        int dheight = this.mDrawable.getIntrinsicHeight();
        int vwidth = this.mAllowCrop ? this.getCropSize() : this.getWidth();
        int vheight = this.mAllowCrop ? this.getCropSize() : this.getHeight();
        this.mMinScale = dwidth < vwidth && dheight < vheight && !this.mAllowCrop ? 1.0f : this.getScale();
        this.mMaxScale = Math.max(this.mMinScale * 8.0f, 8.0f);
    }

    private int getCropSize() {
        return this.mCropSize > 0 ? this.mCropSize : sCropSize;
    }

    private float getScale() {
        return (float)Math.sqrt((float)Math.pow(this.getValue(this.mMatrix, 0), 2.0) + (float)Math.pow(this.getValue(this.mMatrix, 3), 2.0));
    }

    private float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mValues);
        return this.mValues[whichValue];
    }

    private void scale(float newScale, float centerX, float centerY) {
        this.mMatrix.postRotate(-this.mRotation, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        newScale = Math.max(newScale, this.mMinScale);
        newScale = Math.min(newScale, this.mMaxScale);
        float currentScale = this.getScale();
        float factor = newScale / currentScale;
        this.mMatrix.postScale(factor, factor, centerX, centerY);
        this.snap();
        this.mMatrix.postRotate(this.mRotation, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        this.invalidate();
    }

    private boolean translate(float tx, float ty) {
        this.mTranslateRect.set(this.mTempSrc);
        this.mMatrix.mapRect(this.mTranslateRect);
        float maxLeft = this.mAllowCrop ? (float)this.mCropRect.left : 0.0f;
        float maxRight = this.mAllowCrop ? (float)this.mCropRect.right : (float)this.getWidth();
        float l = this.mTranslateRect.left;
        float r = this.mTranslateRect.right;
        float translateX = this.mAllowCrop ? Math.max(maxLeft - this.mTranslateRect.right, Math.min(maxRight - this.mTranslateRect.left, tx)) : (r - l < maxRight - maxLeft ? maxLeft + (maxRight - maxLeft - (r + l)) / 2.0f : Math.max(maxRight - r, Math.min(maxLeft - l, tx)));
        float maxTop = this.mAllowCrop ? (float)this.mCropRect.top : 0.0f;
        float maxBottom = this.mAllowCrop ? (float)this.mCropRect.bottom : (float)this.getHeight();
        float t = this.mTranslateRect.top;
        float b = this.mTranslateRect.bottom;
        float translateY = this.mAllowCrop ? Math.max(maxTop - this.mTranslateRect.bottom, Math.min(maxBottom - this.mTranslateRect.top, ty)) : (b - t < maxBottom - maxTop ? maxTop + (maxBottom - maxTop - (b + t)) / 2.0f : Math.max(maxBottom - b, Math.min(maxTop - t, ty)));
        this.mMatrix.postTranslate(translateX, translateY);
        this.invalidate();
        return translateX == tx && translateY == ty;
    }

    private void snap() {
        this.mTranslateRect.set(this.mTempSrc);
        this.mMatrix.mapRect(this.mTranslateRect);
        float maxLeft = this.mAllowCrop ? (float)this.mCropRect.left : 0.0f;
        float maxRight = this.mAllowCrop ? (float)this.mCropRect.right : (float)this.getWidth();
        float l = this.mTranslateRect.left;
        float r = this.mTranslateRect.right;
        float translateX = r - l < maxRight - maxLeft ? maxLeft + (maxRight - maxLeft - (r + l)) / 2.0f : (l > maxLeft ? maxLeft - l : (r < maxRight ? maxRight - r : 0.0f));
        float maxTop = this.mAllowCrop ? (float)this.mCropRect.top : 0.0f;
        float maxBottom = this.mAllowCrop ? (float)this.mCropRect.bottom : (float)this.getHeight();
        float t = this.mTranslateRect.top;
        float b = this.mTranslateRect.bottom;
        float translateY = b - t < maxBottom - maxTop ? maxTop + (maxBottom - maxTop - (b + t)) / 2.0f : (t > maxTop ? maxTop - t : (b < maxBottom ? maxBottom - b : 0.0f));
        if (Math.abs(translateX) > 20.0f || Math.abs(translateY) > 20.0f) {
            this.mSnapRunnable.start(translateX, translateY);
        } else {
            this.mMatrix.postTranslate(translateX, translateY);
            this.invalidate();
        }
    }

    private void rotate(float degrees, boolean animate) {
        if (animate) {
            this.mRotateRunnable.start(degrees);
        } else {
            this.mRotation += degrees;
            this.mMatrix.postRotate(degrees, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            this.invalidate();
        }
    }

    private void initialize() {
        Context context = this.getContext();
        if (!sInitialized) {
            sInitialized = true;
            Resources resources = context.getApplicationContext().getResources();
            sCropSize = resources.getDimensionPixelSize(R.dimen.photo_crop_width);
            sCropDimPaint = new Paint();
            sCropDimPaint.setAntiAlias(true);
            sCropDimPaint.setColor(resources.getColor(R.color.photo_crop_dim_color));
            sCropDimPaint.setStyle(Paint.Style.FILL);
            sCropPaint = new Paint();
            sCropPaint.setAntiAlias(true);
            sCropPaint.setColor(resources.getColor(R.color.photo_crop_highlight_color));
            sCropPaint.setStyle(Paint.Style.STROKE);
            sCropPaint.setStrokeWidth(resources.getDimension(R.dimen.photo_crop_stroke_width));
            ViewConfiguration configuration = ViewConfiguration.get((Context)context);
            int touchSlop = configuration.getScaledTouchSlop();
            sTouchSlopSquare = touchSlop * touchSlop;
        }
        this.mGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this, null);
        this.mScaleGetureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this);
        this.mQuickScaleEnabled = ScaleGestureDetectorCompat.isQuickScaleEnabled((Object)this.mScaleGetureDetector);
        this.mScaleRunnable = new ScaleRunnable(this);
        this.mTranslateRunnable = new TranslateRunnable(this);
        this.mSnapRunnable = new SnapRunnable(this);
        this.mRotateRunnable = new RotateRunnable(this);
    }

    public void setMaxInitialScale(float f) {
        this.mMaxInitialScaleFactor = f;
    }

    @Override
    public void loadImageIfNecessary(final boolean isInLayoutPass) {
        ImageLoader.ImageContainer newContainer;
        boolean isFullyWrapContent;
        int width = this.getWidth();
        int height = this.getHeight();
        boolean wrapWidth = false;
        boolean wrapHeight = false;
        if (this.getLayoutParams() != null) {
            wrapWidth = this.getLayoutParams().width == -2;
            wrapHeight = this.getLayoutParams().height == -2;
        }
        boolean bl = isFullyWrapContent = wrapWidth && wrapHeight;
        if (width == 0 && height == 0 && !isFullyWrapContent) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            if (this.mImageContainer != null) {
                this.mImageContainer.cancelRequest();
                this.mImageContainer = null;
            }
            this.setDefaultImageOrNull();
            return;
        }
        if (this.mImageContainer != null && this.mImageContainer.getRequestUrl() != null) {
            if (this.mImageContainer.getRequestUrl().equals(this.mUrl)) {
                return;
            }
            this.mImageContainer.cancelRequest();
            this.setDefaultImageOrNull();
        }
        int maxWidth = wrapWidth ? 0 : width;
        int maxHeight = wrapHeight ? 0 : height;
        this.mImageContainer = newContainer = this.mImageLoader.get(this.mUrl, new ImageLoader.ImageListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                if (PhotoView.this.mErrorImageId != 0) {
                    PhotoView.this.bindResource(PhotoView.this.mErrorImageId);
                }
            }

            @Override
            public void onResponse(final ImageLoader.ImageContainer response, boolean isImmediate) {
                if (isImmediate && isInLayoutPass) {
                    PhotoView.this.post(new Runnable(){

                        @Override
                        public void run() {
                            this.onResponse(response, false);
                        }
                    });
                    return;
                }
                if (response.getBitmap() != null) {
                    PhotoView.this.bindPhoto(response.getBitmap());
                    if (null != PhotoView.this.getImageListener()) {
                        PhotoView.this.getImageListener().onResponse(response.getBitmap());
                    }
                } else if (PhotoView.this.mDefaultImageId != 0) {
                    PhotoView.this.bindResource(PhotoView.this.mDefaultImageId);
                }
            }
        }, maxWidth, maxHeight);
    }

    @Override
    protected void setDefaultImageOrNull() {
        if (this.mDefaultImageId != 0) {
            this.bindResource(this.mDefaultImageId);
        } else {
            this.bindPhoto(null);
        }
    }

    public int getActualHeight() {
        if (this.mDrawable != null) {
            return this.mDrawable.getIntrinsicHeight();
        }
        return 0;
    }

    public int getActualWidth() {
        if (this.mDrawable != null) {
            return this.mDrawable.getIntrinsicWidth();
        }
        return 0;
    }

    private static class RotateRunnable
    implements Runnable {
        private static final long NEVER = -1L;
        private final PhotoView mHeader;
        private float mTargetRotation;
        private float mAppliedRotation;
        private float mVelocity;
        private long mLastRuntime;
        private boolean mRunning;
        private boolean mStop;

        public RotateRunnable(PhotoView header) {
            this.mHeader = header;
        }

        public void start(float rotation) {
            if (this.mRunning) {
                return;
            }
            this.mTargetRotation = rotation;
            this.mVelocity = this.mTargetRotation / 500.0f;
            this.mAppliedRotation = 0.0f;
            this.mLastRuntime = -1L;
            this.mStop = false;
            this.mRunning = true;
            this.mHeader.post(this);
        }

        public void stop() {
            this.mRunning = false;
            this.mStop = true;
        }

        @Override
        public void run() {
            if (this.mStop) {
                return;
            }
            if (this.mAppliedRotation != this.mTargetRotation) {
                long now = System.currentTimeMillis();
                long delta = this.mLastRuntime != -1L ? now - this.mLastRuntime : 0L;
                float rotationAmount = this.mVelocity * (float)delta;
                if (this.mAppliedRotation < this.mTargetRotation && this.mAppliedRotation + rotationAmount > this.mTargetRotation || this.mAppliedRotation > this.mTargetRotation && this.mAppliedRotation + rotationAmount < this.mTargetRotation) {
                    rotationAmount = this.mTargetRotation - this.mAppliedRotation;
                }
                this.mHeader.rotate(rotationAmount, false);
                this.mAppliedRotation += rotationAmount;
                if (this.mAppliedRotation == this.mTargetRotation) {
                    this.stop();
                }
                this.mLastRuntime = now;
            }
            if (this.mStop) {
                return;
            }
            this.mHeader.post(this);
        }
    }

    private static class SnapRunnable
    implements Runnable {
        private static final long NEVER = -1L;
        private final PhotoView mHeader;
        private float mTranslateX;
        private float mTranslateY;
        private long mStartRunTime = -1L;
        private boolean mRunning;
        private boolean mStop;

        public SnapRunnable(PhotoView header) {
            this.mHeader = header;
        }

        public boolean start(float translateX, float translateY) {
            if (this.mRunning) {
                return false;
            }
            this.mStartRunTime = -1L;
            this.mTranslateX = translateX;
            this.mTranslateY = translateY;
            this.mStop = false;
            this.mRunning = true;
            this.mHeader.postDelayed(this, 250L);
            return true;
        }

        public void stop() {
            this.mRunning = false;
            this.mStop = true;
        }

        @Override
        public void run() {
            float transY;
            float transX;
            float delta;
            if (this.mStop) {
                return;
            }
            long now = System.currentTimeMillis();
            float f = delta = this.mStartRunTime != -1L ? (float)(now - this.mStartRunTime) : 0.0f;
            if (this.mStartRunTime == -1L) {
                this.mStartRunTime = now;
            }
            if (delta >= 100.0f) {
                transX = this.mTranslateX;
                transY = this.mTranslateY;
            } else {
                transX = this.mTranslateX / (100.0f - delta) * 10.0f;
                transY = this.mTranslateY / (100.0f - delta) * 10.0f;
                if (Math.abs(transX) > Math.abs(this.mTranslateX) || transX == Float.NaN) {
                    transX = this.mTranslateX;
                }
                if (Math.abs(transY) > Math.abs(this.mTranslateY) || transY == Float.NaN) {
                    transY = this.mTranslateY;
                }
            }
            this.mHeader.translate(transX, transY);
            this.mTranslateX -= transX;
            this.mTranslateY -= transY;
            if (this.mTranslateX == 0.0f && this.mTranslateY == 0.0f) {
                this.stop();
            }
            if (this.mStop) {
                return;
            }
            this.mHeader.post(this);
        }
    }

    private static class TranslateRunnable
    implements Runnable {
        private static final float DECELERATION_RATE = 1000.0f;
        private static final long NEVER = -1L;
        private final PhotoView mHeader;
        private float mVelocityX;
        private float mVelocityY;
        private long mLastRunTime = -1L;
        private boolean mRunning;
        private boolean mStop;

        public TranslateRunnable(PhotoView header) {
            this.mHeader = header;
        }

        public boolean start(float velocityX, float velocityY) {
            if (this.mRunning) {
                return false;
            }
            this.mLastRunTime = -1L;
            this.mVelocityX = velocityX;
            this.mVelocityY = velocityY;
            this.mStop = false;
            this.mRunning = true;
            this.mHeader.post(this);
            return true;
        }

        public void stop() {
            this.mRunning = false;
            this.mStop = true;
        }

        @Override
        public void run() {
            if (this.mStop) {
                return;
            }
            long now = System.currentTimeMillis();
            float delta = this.mLastRunTime != -1L ? (float)(now - this.mLastRunTime) / 1000.0f : 0.0f;
            boolean didTranslate = this.mHeader.translate(this.mVelocityX * delta, this.mVelocityY * delta);
            this.mLastRunTime = now;
            float slowDown = 1000.0f * delta;
            if (this.mVelocityX > 0.0f) {
                this.mVelocityX -= slowDown;
                if (this.mVelocityX < 0.0f) {
                    this.mVelocityX = 0.0f;
                }
            } else {
                this.mVelocityX += slowDown;
                if (this.mVelocityX > 0.0f) {
                    this.mVelocityX = 0.0f;
                }
            }
            if (this.mVelocityY > 0.0f) {
                this.mVelocityY -= slowDown;
                if (this.mVelocityY < 0.0f) {
                    this.mVelocityY = 0.0f;
                }
            } else {
                this.mVelocityY += slowDown;
                if (this.mVelocityY > 0.0f) {
                    this.mVelocityY = 0.0f;
                }
            }
            if (this.mVelocityX == 0.0f && this.mVelocityY == 0.0f || !didTranslate) {
                this.stop();
                this.mHeader.snap();
            }
            if (this.mStop) {
                return;
            }
            this.mHeader.post(this);
        }
    }

    private static class ScaleRunnable
    implements Runnable {
        private final PhotoView mHeader;
        private float mCenterX;
        private float mCenterY;
        private boolean mZoomingIn;
        private float mTargetScale;
        private float mStartScale;
        private float mVelocity;
        private long mStartTime;
        private boolean mRunning;
        private boolean mStop;

        public ScaleRunnable(PhotoView header) {
            this.mHeader = header;
        }

        public boolean start(float startScale, float targetScale, float centerX, float centerY) {
            if (this.mRunning) {
                return false;
            }
            this.mCenterX = centerX;
            this.mCenterY = centerY;
            this.mTargetScale = targetScale;
            this.mStartTime = System.currentTimeMillis();
            this.mStartScale = startScale;
            this.mZoomingIn = this.mTargetScale > this.mStartScale;
            this.mVelocity = (this.mTargetScale - this.mStartScale) / 300.0f;
            this.mRunning = true;
            this.mStop = false;
            this.mHeader.post(this);
            return true;
        }

        public void stop() {
            this.mRunning = false;
            this.mStop = true;
        }

        @Override
        public void run() {
            if (this.mStop) {
                return;
            }
            long now = System.currentTimeMillis();
            long ellapsed = now - this.mStartTime;
            float newScale = this.mStartScale + this.mVelocity * (float)ellapsed;
            this.mHeader.scale(newScale, this.mCenterX, this.mCenterY);
            if (newScale == this.mTargetScale || this.mZoomingIn == newScale > this.mTargetScale) {
                this.mHeader.scale(this.mTargetScale, this.mCenterX, this.mCenterY);
                this.stop();
            }
            if (!this.mStop) {
                this.mHeader.post(this);
            }
        }
    }
}

