/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox.multipart;

import com.android.volley.misc.MultipartUtils;
import com.android.volley.toolbox.multipart.BasePart;
import com.android.volley.toolbox.multipart.Boundary;
import com.android.volley.toolbox.multipart.UrlEncodingHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public final class StringPart
extends BasePart {
    private final byte[] valueBytes;

    public StringPart(String name, String value, String charset) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        final String partName = UrlEncodingHelper.encode(name, "US-ASCII");
        if (charset == null) {
            charset = "ISO-8859-1";
        }
        String partCharset = charset;
        try {
            this.valueBytes = value.getBytes(partCharset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.headersProvider = new BasePart.IHeadersProvider(){

            @Override
            public String getContentDisposition() {
                return String.format("Content-Disposition: form-data; name=\"%s\"", partName);
            }

            @Override
            public String getContentType() {
                return "Content-Type: text/plain";
            }

            @Override
            public String getContentTransferEncoding() {
                return "Content-Transfer-Encoding: 8bit";
            }
        };
    }

    public StringPart(String name, String value) {
        this(name, value, null);
    }

    @Override
    public long getContentLength(Boundary boundary) {
        return this.getHeader(boundary).length + this.valueBytes.length + MultipartUtils.CRLF_BYTES.length;
    }

    @Override
    public void writeTo(OutputStream out, Boundary boundary) throws IOException {
        out.write(this.getHeader(boundary));
        out.write(this.valueBytes);
        out.write(MultipartUtils.CRLF_BYTES);
    }
}

