/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.text.TextUtils;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.error.AuthFailureError;
import com.android.volley.misc.MultipartUtils;
import com.android.volley.request.MultiPartRequest;
import com.android.volley.toolbox.HttpStack;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;

public class HurlStack
implements HttpStack {
    private UrlRewriter mUrlRewriter;
    private final SSLSocketFactory mSslSocketFactory;
    private String mUserAgent;

    public HurlStack() {
        this(null);
    }

    public HurlStack(UrlRewriter urlRewriter) {
        this(urlRewriter, null);
    }

    public HurlStack(UrlRewriter urlRewriter, SSLSocketFactory sslSocketFactory) {
        this.mUrlRewriter = urlRewriter;
        this.mSslSocketFactory = sslSocketFactory;
    }

    public HurlStack(UrlRewriter urlRewriter, SSLSocketFactory sslSocketFactory, String userAgent) {
        this.mUrlRewriter = urlRewriter;
        this.mSslSocketFactory = sslSocketFactory;
        this.mUserAgent = userAgent;
    }

    @Override
    public HttpResponse performRequest(Request<?> request, Map<String, String> additionalHeaders) throws AuthFailureError, IOException {
        String url = request.getUrl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(request.getHeaders());
        map.putAll(additionalHeaders);
        if (this.mUrlRewriter != null) {
            String rewritten = this.mUrlRewriter.rewriteUrl(url);
            if (rewritten == null) {
                throw new IOException("URL blocked by rewriter: " + url);
            }
            url = rewritten;
        }
        URL parsedUrl = new URL(url);
        HttpURLConnection connection = this.openConnection(parsedUrl, request);
        if (!TextUtils.isEmpty((CharSequence)this.mUserAgent)) {
            connection.setRequestProperty("User-Agent", this.mUserAgent);
        }
        for (String headerName : map.keySet()) {
            connection.addRequestProperty(headerName, (String)map.get(headerName));
        }
        if (request instanceof MultiPartRequest) {
            HurlStack.setConnectionParametersForMultipartRequest(connection, request);
        } else {
            HurlStack.setConnectionParametersForRequest(connection, request);
        }
        ProtocolVersion protocolVersion = new ProtocolVersion("HTTP", 1, 1);
        int responseCode = connection.getResponseCode();
        if (responseCode == -1) {
            throw new IOException("Could not retrieve response code from HttpUrlConnection.");
        }
        BasicStatusLine responseStatus = new BasicStatusLine(protocolVersion, connection.getResponseCode(), connection.getResponseMessage());
        BasicHttpResponse response = new BasicHttpResponse((StatusLine)responseStatus);
        if (HurlStack.hasResponseBody(request.getMethod(), responseStatus.getStatusCode())) {
            response.setEntity(HurlStack.entityFromConnection(connection));
        }
        for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
            if (header.getKey() == null) continue;
            BasicHeader h = new BasicHeader(header.getKey(), header.getValue().get(0));
            response.addHeader((Header)h);
        }
        return response;
    }

    private static boolean hasResponseBody(int requestMethod, int responseCode) {
        return requestMethod != 4 && (100 > responseCode || responseCode >= 200) && responseCode != 204 && responseCode != 304;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setConnectionParametersForMultipartRequest(HttpURLConnection connection, Request<?> request) throws IOException, ProtocolException {
        String charset = ((MultiPartRequest)request).getProtocolCharset();
        int curTime = (int)(System.currentTimeMillis() / 1000L);
        String boundary = "--" + curTime;
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", String.format("multipart/form-data; charset=%s; boundary=%s", charset, curTime));
        Map<String, MultiPartRequest.MultiPartParam> multipartParams = ((MultiPartRequest)request).getMultipartParams();
        Map<String, String> filesToUpload = ((MultiPartRequest)request).getFilesToUpload();
        if (((MultiPartRequest)request).isFixedStreamingMode()) {
            int contentLength = MultipartUtils.getContentLengthForMultipartRequest(boundary, multipartParams, filesToUpload);
            connection.setFixedLengthStreamingMode(contentLength);
        } else {
            connection.setChunkedStreamingMode(0);
        }
        Response.ProgressListener progressListener = (Response.ProgressListener)((Object)request);
        try (PrintWriter writer = null;){
            OutputStream out = connection.getOutputStream();
            writer = new PrintWriter((Writer)new OutputStreamWriter(out, charset), true);
            for (String key : multipartParams.keySet()) {
                MultiPartRequest.MultiPartParam param = multipartParams.get(key);
                writer.append(boundary).append("\r\n").append(String.format("Content-Disposition: form-data; name=\"%s\"", key)).append("\r\n").append("Content-Type: " + param.contentType).append("\r\n").append("\r\n").append(param.value).append("\r\n").flush();
            }
            for (String key : filesToUpload.keySet()) {
                File file = new File(filesToUpload.get(key));
                if (!file.exists()) {
                    throw new IOException(String.format("File not found: %s", file.getAbsolutePath()));
                }
                if (file.isDirectory()) {
                    throw new IOException(String.format("File is a directory: %s", file.getAbsolutePath()));
                }
                writer.append(boundary).append("\r\n").append(String.format("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", key, file.getName())).append("\r\n").append("Content-Type: application/octet-stream").append("\r\n").append("Content-Transfer-Encoding: binary").append("\r\n").append("\r\n").flush();
                BufferedInputStream input = null;
                try {
                    FileInputStream fis = new FileInputStream(file);
                    int transferredBytes = 0;
                    int totalSize = (int)file.length();
                    input = new BufferedInputStream(fis);
                    int bufferLength = 0;
                    byte[] buffer = new byte[1024];
                    while ((bufferLength = input.read(buffer)) > 0) {
                        out.write(buffer, 0, bufferLength);
                        progressListener.onProgress(transferredBytes += bufferLength, totalSize);
                    }
                    out.flush();
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                writer.append("\r\n").flush();
            }
            writer.append(boundary + "--").append("\r\n").flush();
        }
    }

    private static HttpEntity entityFromConnection(HttpURLConnection connection) {
        InputStream inputStream;
        BasicHttpEntity entity = new BasicHttpEntity();
        try {
            inputStream = connection.getInputStream();
        }
        catch (IOException ioe) {
            inputStream = connection.getErrorStream();
        }
        entity.setContent(inputStream);
        entity.setContentLength((long)connection.getContentLength());
        entity.setContentEncoding(connection.getContentEncoding());
        entity.setContentType(connection.getContentType());
        return entity;
    }

    protected HttpURLConnection createConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(HttpURLConnection.getFollowRedirects());
        return connection;
    }

    private HttpURLConnection openConnection(URL url, Request<?> request) throws IOException {
        HttpURLConnection connection = this.createConnection(url);
        int timeoutMs = request.getTimeoutMs();
        connection.setConnectTimeout(timeoutMs);
        connection.setReadTimeout(timeoutMs);
        connection.setUseCaches(false);
        connection.setDoInput(true);
        if ("https".equals(url.getProtocol()) && this.mSslSocketFactory != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.mSslSocketFactory);
        }
        return connection;
    }

    static void setConnectionParametersForRequest(HttpURLConnection connection, Request<?> request) throws IOException, AuthFailureError {
        switch (request.getMethod()) {
            case -1: {
                byte[] postBody = request.getPostBody();
                if (postBody == null) break;
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.addRequestProperty("Content-Type", request.getPostBodyContentType());
                DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                out.write(postBody);
                out.close();
                break;
            }
            case 0: {
                connection.setRequestMethod("GET");
                break;
            }
            case 3: {
                connection.setRequestMethod("DELETE");
                break;
            }
            case 1: {
                connection.setRequestMethod("POST");
                HurlStack.addBodyIfExists(connection, request);
                break;
            }
            case 2: {
                connection.setRequestMethod("PUT");
                HurlStack.addBodyIfExists(connection, request);
                break;
            }
            case 4: {
                connection.setRequestMethod("HEAD");
                break;
            }
            case 5: {
                connection.setRequestMethod("OPTIONS");
                break;
            }
            case 6: {
                connection.setRequestMethod("TRACE");
                break;
            }
            case 7: {
                if (request.shouldOverridePatch()) {
                    connection.setRequestMethod("POST");
                    connection.setRequestProperty("X-HTTP-Method-Override", "PATCH");
                } else {
                    connection.setRequestMethod("PATCH");
                }
                HurlStack.addBodyIfExists(connection, request);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown method type.");
            }
        }
    }

    private static void addBodyIfExists(HttpURLConnection connection, Request<?> request) throws IOException, AuthFailureError {
        byte[] body = request.getBody();
        if (body != null) {
            Response.ProgressListener progressListener = null;
            if (request instanceof Response.ProgressListener) {
                progressListener = (Response.ProgressListener)((Object)request);
            }
            connection.setDoOutput(true);
            connection.addRequestProperty("Content-Type", request.getBodyContentType());
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            if (progressListener != null) {
                int transferredBytes = 0;
                int totalSize = body.length;
                int offset = 0;
                int chunkSize = Math.min(2048, Math.max(totalSize - offset, 0));
                while (chunkSize > 0 && offset + chunkSize <= totalSize) {
                    out.write(body, offset, chunkSize);
                    progressListener.onProgress(transferredBytes += chunkSize, totalSize);
                    chunkSize = Math.min(chunkSize, Math.max(totalSize - (offset += chunkSize), 0));
                }
            } else {
                out.write(body);
            }
            out.close();
        }
    }

    public static interface UrlRewriter {
        public String rewriteUrl(String var1);
    }
}

