/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.cache;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Build;
import android.support.v4.util.LruCache;
import com.android.volley.toolbox.ImageCache;

public class LruImageCache
implements ImageCache {
    private LruCache<String, Bitmap> mLruCache;

    public LruImageCache() {
        int maxMemory = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int cacheSize = maxMemory / 8;
        this.mLruCache = new LruCache<String, Bitmap>(cacheSize){

            @SuppressLint(value={"NewApi"})
            protected int sizeOf(String key, Bitmap bitmap) {
                if (Build.VERSION.SDK_INT >= 12) {
                    return bitmap.getByteCount() / 1024;
                }
                return bitmap.getRowBytes() * bitmap.getHeight() / 1024;
            }
        };
    }

    @Override
    public Bitmap getBitmap(String key) {
        return (Bitmap)this.mLruCache.get((Object)key);
    }

    @Override
    public void putBitmap(String key, Bitmap bitmap) {
        this.mLruCache.put((Object)key, (Object)bitmap);
    }

    @Override
    public void invalidateBitmap(String url) {
        this.mLruCache.remove((Object)url);
    }

    @Override
    public void clear() {
        this.mLruCache.evictAll();
    }
}

