/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.cache;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import com.android.volley.Cache;
import com.android.volley.VolleyLog;
import com.android.volley.cache.DiskBasedCache;
import com.android.volley.misc.DiskLruCache;
import com.android.volley.misc.IOUtils;
import com.android.volley.misc.ImageUtils;
import com.android.volley.misc.Utils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DiskLruBasedCache
implements Cache {
    private static final String TAG = "DiskLruImageCache";
    private static final int DEFAULT_MEM_CACHE_SIZE = 5120;
    private static final int DEFAULT_DISK_CACHE_SIZE = 0xA00000;
    private static final boolean DEFAULT_MEM_CACHE_ENABLED = true;
    private static final boolean DEFAULT_DISK_CACHE_ENABLED = true;
    private static final boolean DEFAULT_INIT_DISK_CACHE_ON_CREATE = false;
    private static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.JPEG;
    private static final int DEFAULT_COMPRESS_QUALITY = 70;
    private static final int DISK_CACHE_INDEX = 0;
    private static final int APP_VERSION = 1;
    private static final int VALUE_COUNT = 1;
    private DiskLruCache mDiskLruCache;
    private Bitmap.CompressFormat mCompressFormat = DEFAULT_COMPRESS_FORMAT;
    private static int IO_BUFFER_SIZE = 8192;
    private int mCompressQuality = 70;
    private final Object mDiskCacheLock = new Object();
    private boolean mDiskCacheStarting = true;
    private ImageCacheParams mCacheParams;

    public DiskLruBasedCache(File root) {
        this.mCacheParams = new ImageCacheParams(root);
    }

    public DiskLruBasedCache(ImageCacheParams cacheParams) {
        this.mCacheParams = cacheParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBitmap(String data, Bitmap value) {
        if (data == null || value == null) {
            return;
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                String key = DiskLruBasedCache.hashKeyForDisk(data);
                OutputStream out = null;
                try {
                    DiskLruCache.Snapshot snapshot = this.mDiskLruCache.get(key);
                    if (snapshot == null) {
                        DiskLruCache.Editor editor = this.mDiskLruCache.edit(key);
                        if (editor != null) {
                            out = editor.newOutputStream(0);
                            value.compress(this.mCacheParams.compressFormat, this.mCacheParams.compressQuality, out);
                            editor.commit();
                            out.close();
                        }
                    } else {
                        snapshot.getInputStream(0).close();
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("addBitmapToCache - " + e));
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("addBitmapToCache - " + e));
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmap(String data) {
        String key = DiskLruBasedCache.hashKeyForDisk(data);
        Bitmap bitmap = null;
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            while (this.mDiskCacheStarting) {
                try {
                    this.mDiskCacheLock.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.mDiskLruCache != null) {
                InputStream inputStream = null;
                try {
                    DiskLruCache.Snapshot snapshot = this.mDiskLruCache.get(key);
                    if (snapshot != null && (inputStream = snapshot.getInputStream(0)) != null) {
                        FileDescriptor fd = ((FileInputStream)inputStream).getFD();
                        bitmap = ImageUtils.decodeSampledBitmapFromDescriptor(fd, Integer.MAX_VALUE, Integer.MAX_VALUE);
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("getBitmapFromDiskCache - " + e));
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
            return bitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        boolean contained = false;
        try (DiskLruCache.Snapshot snapshot = null;){
            snapshot = this.mDiskLruCache.get(key);
            contained = snapshot != null;
        }
        return contained;
    }

    public void clearCache() {
        try {
            this.mDiskLruCache.delete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getCacheFolder() {
        return this.mDiskLruCache.getDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDiskCache() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache == null || this.mDiskLruCache.isClosed()) {
                File diskCacheDir = this.mCacheParams.diskCacheDir;
                if (this.mCacheParams.diskCacheEnabled && diskCacheDir != null) {
                    if (!diskCacheDir.exists()) {
                        diskCacheDir.mkdirs();
                    }
                    if (Utils.getUsableSpace(diskCacheDir) > (long)this.mCacheParams.diskCacheSize) {
                        try {
                            this.mDiskLruCache = DiskLruCache.open(diskCacheDir, 1, 1, this.mCacheParams.diskCacheSize);
                        }
                        catch (IOException e) {
                            this.mCacheParams.diskCacheDir = null;
                            VolleyLog.e("initDiskCache - " + e, new Object[0]);
                        }
                    }
                }
            }
            this.mDiskCacheStarting = false;
            this.mDiskCacheLock.notifyAll();
        }
    }

    public static String hashKeyForDisk(String key) {
        String cacheKey;
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            mDigest.update(key.getBytes());
            cacheKey = DiskLruBasedCache.bytesToHexString(mDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            cacheKey = String.valueOf(key.hashCode());
        }
        return cacheKey;
    }

    private static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    private String getFilenameForKey(String key) {
        int firstHalfLength = key.length() / 2;
        String localFilename = String.valueOf(key.substring(0, firstHalfLength).hashCode());
        localFilename = localFilename + String.valueOf(key.substring(firstHalfLength).hashCode());
        return localFilename;
    }

    public File getFileForKey(String key) {
        return new File(this.mCacheParams.diskCacheDir, key + ".0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Cache.Entry get(String data) {
        String key = DiskLruBasedCache.hashKeyForDisk(data);
        if (data == null) {
            return null;
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            Cache.Entry entry2;
            while (this.mDiskCacheStarting) {
                try {
                    this.mDiskCacheLock.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.mDiskLruCache == null) return null;
            InputStream inputStream = null;
            File file = this.getFileForKey(key);
            try {
                DiskLruCache.Snapshot snapshot = this.mDiskLruCache.get(key);
                if (snapshot == null) return null;
                inputStream = snapshot.getInputStream(0);
                if (inputStream == null) return null;
                IOUtils.CountingInputStream cis = new IOUtils.CountingInputStream(inputStream);
                DiskBasedCache.CacheHeader entry = DiskBasedCache.CacheHeader.readHeader(cis);
                byte[] dataBytes = IOUtils.streamToBytes(cis, (int)(file.length() - cis.getBytesRead()));
                entry2 = entry.toCacheEntry(dataBytes);
            }
            catch (IOException e) {
                this.remove(key);
                Log.e((String)TAG, (String)("getDiskLruBasedCache - " + e));
                Cache.Entry entry = null;
                return entry;
            }
            catch (OutOfMemoryError e) {
                VolleyLog.e("Caught OOM for %d byte image, path=%s: %s", file.length(), file.getAbsolutePath(), e.toString());
                Cache.Entry entry = null;
                return entry;
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e2) {}
            }
            return entry2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String data, Cache.Entry value) {
        if (data == null || value == null) {
            return;
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                String key = DiskLruBasedCache.hashKeyForDisk(data);
                OutputStream out = null;
                try {
                    DiskLruCache.Editor editor = this.mDiskLruCache.edit(key);
                    if (editor != null) {
                        out = editor.newOutputStream(0);
                        DiskBasedCache.CacheHeader e = new DiskBasedCache.CacheHeader(key, value);
                        e.writeHeader(out);
                        out.write(value.data);
                        editor.commit();
                        out.close();
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("putDiskLruBasedCache - " + e));
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("putDiskLruBasedCache - " + e));
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    @Override
    public void initialize() {
        this.initDiskCache();
    }

    @Override
    public void invalidate(String key, boolean fullExpire) {
        Cache.Entry entry = this.get(key);
        if (entry != null) {
            entry.softTtl = -1L;
            if (fullExpire) {
                entry.ttl = -1L;
            }
            this.put(key, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String data) {
        if (data == null) {
            return;
        }
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                String key = DiskLruBasedCache.hashKeyForDisk(data);
                try {
                    this.mDiskLruCache.remove(key);
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("removeDiskLruBasedCache - " + e));
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("removeDiskLruBasedCache - " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            this.mDiskCacheStarting = true;
            if (this.mDiskLruCache != null && !this.mDiskLruCache.isClosed()) {
                try {
                    this.mDiskLruCache.delete();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("clearCache - " + e));
                }
                this.mDiskLruCache = null;
                this.initDiskCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    this.mDiskLruCache.flush();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("flush - " + e));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mDiskCacheLock;
        synchronized (object) {
            if (this.mDiskLruCache != null) {
                try {
                    if (!this.mDiskLruCache.isClosed()) {
                        this.mDiskLruCache.close();
                        this.mDiskLruCache = null;
                    }
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)("close - " + e));
                }
            }
        }
    }

    static /* synthetic */ Bitmap.CompressFormat access$000() {
        return DEFAULT_COMPRESS_FORMAT;
    }

    public static class ImageCacheParams {
        public int memCacheSize = 5120;
        public int diskCacheSize = 0xA00000;
        public File diskCacheDir;
        public Bitmap.CompressFormat compressFormat = DiskLruBasedCache.access$000();
        public int compressQuality = 70;
        public boolean memoryCacheEnabled = true;
        public boolean diskCacheEnabled = true;
        public boolean initDiskCacheOnCreate = false;

        public ImageCacheParams(File rootDirectory, int maxCacheSizeInBytes) {
            this.diskCacheDir = rootDirectory;
            this.memCacheSize = maxCacheSizeInBytes;
        }

        public ImageCacheParams(Context context, String rootDirectory, int maxCacheSizeInBytes) {
            this.diskCacheDir = Utils.getDiskCacheDir(context, rootDirectory);
            this.memCacheSize = maxCacheSizeInBytes;
        }

        public ImageCacheParams(Context context, String rootDirectory) {
            this.diskCacheDir = Utils.getDiskCacheDir(context, rootDirectory);
        }

        public ImageCacheParams(File rootDirectory) {
            this.diskCacheDir = rootDirectory;
        }

        public void setMemCacheSizePercent(float percent) {
            if (percent < 0.01f || percent > 0.8f) {
                throw new IllegalArgumentException("setMemCacheSizePercent - percent must be between 0.01 and 0.8 (inclusive)");
            }
            this.memCacheSize = Math.round(percent * (float)Runtime.getRuntime().maxMemory() / 1024.0f);
        }
    }
}

