/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import dev.ai4j.openai4j.LogLevel;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestLoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestLoggingInterceptor.class);
    private LogLevel logLevel = LogLevel.DEBUG;
    private static final Pattern BEARER_PATTERN = Pattern.compile("(Bearer\\s*sk-)(\\w{2})(\\w+)(\\w{2})");

    public RequestLoggingInterceptor() {
    }

    public RequestLoggingInterceptor(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.log(request);
        return chain.proceed(request);
    }

    private void log(Request request) {
        String message = "Request:\n- method: {}\n- url: {}\n- headers: {}\n- body: {}";
        try {
            switch (this.logLevel) {
                case INFO: {
                    this.logInfo(request, message);
                    break;
                }
                case WARN: {
                    this.logWarn(request, message);
                    break;
                }
                case ERROR: {
                    this.logError(request, message);
                    break;
                }
                default: {
                    this.logDebug(request, message);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.warn("Failed to log request", (Throwable)e);
        }
    }

    private void logInfo(Request request, String message) {
        log.info(message, new Object[]{request.method(), request.url(), RequestLoggingInterceptor.inOneLine(request.headers()), RequestLoggingInterceptor.getBody(request)});
    }

    private void logWarn(Request request, String message) {
        log.warn(message, new Object[]{request.method(), request.url(), RequestLoggingInterceptor.inOneLine(request.headers()), RequestLoggingInterceptor.getBody(request)});
    }

    private void logError(Request request, String message) {
        log.error(message, new Object[]{request.method(), request.url(), RequestLoggingInterceptor.inOneLine(request.headers()), RequestLoggingInterceptor.getBody(request)});
    }

    private void logDebug(Request request, String message) {
        log.debug(message, new Object[]{request.method(), request.url(), RequestLoggingInterceptor.inOneLine(request.headers()), RequestLoggingInterceptor.getBody(request)});
    }

    static String inOneLine(Headers headers) {
        return StreamSupport.stream(headers.spliterator(), false).map(header -> {
            String headerKey = (String)header.component1();
            String headerValue = (String)header.component2();
            if (headerKey.equals("Authorization")) {
                headerValue = RequestLoggingInterceptor.maskAuthorizationHeaderValue(headerValue);
            } else if (headerKey.equals("api-key")) {
                headerValue = RequestLoggingInterceptor.maskApiKeyHeaderValue(headerValue);
            }
            return String.format("[%s: %s]", headerKey, headerValue);
        }).collect(Collectors.joining(", "));
    }

    private static String maskAuthorizationHeaderValue(String authorizationHeaderValue) {
        try {
            Matcher matcher = BEARER_PATTERN.matcher(authorizationHeaderValue);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, matcher.group(1) + matcher.group(2) + "..." + matcher.group(4));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        catch (Exception e) {
            return "Failed to mask the API key.";
        }
    }

    private static String maskApiKeyHeaderValue(String apiKeyHeaderValue) {
        try {
            if (apiKeyHeaderValue.length() <= 4) {
                return apiKeyHeaderValue;
            }
            return apiKeyHeaderValue.substring(0, 2) + "..." + apiKeyHeaderValue.substring(apiKeyHeaderValue.length() - 2);
        }
        catch (Exception e) {
            return "Failed to mask the API key.";
        }
    }

    private static String getBody(Request request) {
        try {
            Buffer buffer = new Buffer();
            request.body().writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (Exception e) {
            log.warn("Exception happened while reading request body", (Throwable)e);
            return "[Exception happened while reading request body. Check logs for more details.]";
        }
    }
}

