/*
 * Decompiled with CFR 0.152.
 */
package mva2.adapter;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import mva2.adapter.ItemSection;
import mva2.adapter.NestedSection;
import mva2.adapter.Section;
import mva2.adapter.decorator.Decorator;
import mva2.adapter.decorator.SectionPositionType;
import mva2.adapter.internal.Notifier;
import mva2.adapter.util.Mode;

public class TreeSection<M>
extends NestedSection
implements Notifier {
    private final ItemSection<M> itemSection;
    private Decorator treeDecorator;
    private boolean isSectionExpanded = true;

    public TreeSection(M item, boolean isExpanded) {
        this.itemSection = new ItemSection<M>(item);
        this.itemSection.setNotifier(this);
        this.sections.add(this.itemSection);
        this.setSectionExpansionMode(Mode.MULTIPLE);
        this.setSectionExpanded(isExpanded);
    }

    public TreeSection getChild(int index) {
        return (TreeSection)this.sections.get(index);
    }

    public M getParent() {
        return this.itemSection.getItem();
    }

    public void setTreeDecorator(Decorator treeDecorator) {
        this.treeDecorator = treeDecorator;
        for (Section section : this.sections) {
            if (!(section instanceof TreeSection)) continue;
            ((TreeSection)section).setTreeDecorator(treeDecorator);
        }
    }

    @Override
    public void addSection(Section section) {
        if (!(section instanceof TreeSection)) {
            throw new IllegalArgumentException();
        }
        this.addTreeSection((TreeSection)section);
        if (null != this.treeDecorator) {
            ((TreeSection)section).setTreeDecorator(this.treeDecorator);
        }
    }

    @Override
    void collapseSection() {
        if (this.isSectionExpanded()) {
            this.onSectionExpansionToggled(0, this.sectionExpansionMode);
        }
    }

    @Override
    int getCount() {
        if (this.isSectionExpanded()) {
            return super.getCount();
        }
        return this.itemSection.getCount();
    }

    @Override
    SectionPositionType getSectionPositionType(int adapterPosition, int sectionPosition, int size) {
        return SectionPositionType.MIDDLE;
    }

    @Override
    int onSectionExpansionToggled(int itemPosition, @NonNull Mode sectionExpansionMode) {
        if (itemPosition < this.getCount() && itemPosition >= 0) {
            if (itemPosition == 0) {
                int count = this.getChildCount() - 1;
                this.setSectionExpanded(!this.isSectionExpanded());
                if (this.isSectionExpanded()) {
                    this.onInserted(1, count);
                } else {
                    this.onRemoved(1, count);
                }
                this.onChanged(0, 1, "section_expansion_payload");
            } else {
                this.onChildSectionExpansionToggled(itemPosition, this.sectionExpansionMode);
            }
        }
        return itemPosition - this.getCount();
    }

    @Override
    void drawDecoration(int itemPosition, @NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        if (itemPosition != 0) {
            this.drawChildSectionDecoration(itemPosition, canvas, parent, state, child, adapterPosition);
        } else if (null != this.treeDecorator) {
            this.treeDecorator.onDraw(canvas, parent, state, child, adapterPosition);
        }
    }

    @Override
    void drawDecorationOver(int itemPosition, @NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        if (itemPosition != 0) {
            this.drawChildSectionDecorationOver(itemPosition, canvas, parent, state, child, adapterPosition);
        } else if (null != this.treeDecorator) {
            this.treeDecorator.onDrawOver(canvas, parent, state, child, adapterPosition);
        }
    }

    @Override
    void getDecorationOffsets(int itemPosition, @NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, int adapterPosition) {
        if (null != this.treeDecorator) {
            this.treeDecorator.getItemOffsets(outRect, view, parent, state, adapterPosition);
        }
        if (itemPosition != 0) {
            this.getChildSectionOffsets(itemPosition, outRect, view, parent, state, adapterPosition);
        }
    }

    @Override
    boolean isSectionExpanded(int itemPosition) {
        if (itemPosition == 0) {
            return this.isSectionExpanded();
        }
        return super.isSectionExpanded(itemPosition);
    }

    @Override
    boolean isSectionVisible() {
        return !this.isSectionHidden();
    }

    private void addTreeSection(TreeSection section) {
        section.setNotifier(this);
        section.setTreeDecorator(this.treeDecorator);
        this.sections.add(section);
    }

    private int getChildCount() {
        int itemCount = 0;
        for (Section section : this.sections) {
            itemCount += section.getCount();
        }
        return itemCount;
    }

    private boolean isSectionExpanded() {
        return this.isSectionExpanded;
    }

    private void setSectionExpanded(boolean sectionExpanded) {
        this.isSectionExpanded = sectionExpanded;
    }
}

