/*
 * Decompiled with CFR 0.152.
 */
package mva2.adapter;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SpanSizeLookup;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mva2.adapter.ItemBinder;
import mva2.adapter.ItemSection;
import mva2.adapter.ItemViewHolder;
import mva2.adapter.NestedSection;
import mva2.adapter.Section;
import mva2.adapter.decorator.SectionPositionType;
import mva2.adapter.internal.Cache;
import mva2.adapter.internal.DecorationDelegate;
import mva2.adapter.internal.ItemTouchCallback;
import mva2.adapter.internal.Notifier;
import mva2.adapter.internal.SparseIntArrayCache;
import mva2.adapter.util.InfiniteLoadingHelper;
import mva2.adapter.util.Mode;

public class MultiViewAdapter
extends RecyclerView.Adapter<ItemViewHolder> {
    private final NestedSection nestedSection = new NestedSection();
    private final List<ItemBinder> itemBinders = new ArrayList<ItemBinder>();
    private final DecorationDelegate decorationDelegate = new DecorationDelegate(this);
    private final Cache spanSizeCache;
    private final Cache positionTypeCache;
    private final Cache viewTypeCache;
    private ItemTouchHelper itemTouchHelper;
    private boolean isInActionMode = false;
    private int spanCount = 1;
    private final SpanSizeLookup spanSizeLookup;
    private final Notifier notifier = new Notifier(){

        @Override
        public void notifySectionItemMoved(Section section, int fromPosition, int toPosition) {
            MultiViewAdapter.this.onDataSetChanged();
            MultiViewAdapter.this.notifyAdapterItemMoved(fromPosition, toPosition);
        }

        @Override
        public void notifySectionRangeChanged(Section section, int positionStart, int itemCount, Object payload) {
            MultiViewAdapter.this.onDataSetChanged();
            MultiViewAdapter.this.notifyAdapterRangeChanged(positionStart, itemCount, payload);
        }

        @Override
        public void notifySectionRangeInserted(Section section, int positionStart, int itemCount) {
            MultiViewAdapter.this.onDataSetChanged();
            MultiViewAdapter.this.notifyAdapterRangeInserted(positionStart, itemCount);
        }

        @Override
        public void notifySectionRangeRemoved(Section section, int positionStart, int itemCount) {
            MultiViewAdapter.this.onDataSetChanged();
            MultiViewAdapter.this.notifyAdapterRangeRemoved(positionStart, itemCount);
        }
    };

    public MultiViewAdapter() {
        this(new SpanSizeLookup(new SparseIntArrayCache()), new SparseIntArrayCache(), new SparseIntArrayCache(), new SparseIntArrayCache());
    }

    MultiViewAdapter(SpanSizeLookup spanSizeLookup, Cache spanSizeCache, Cache positionTypeCache, Cache viewTypeCache) {
        this.spanSizeLookup = spanSizeLookup;
        this.spanSizeLookup.setAdapter(this);
        this.nestedSection.setNotifier(this.notifier);
        this.spanSizeCache = spanSizeCache;
        this.positionTypeCache = positionTypeCache;
        this.viewTypeCache = viewTypeCache;
    }

    public void addSection(@NonNull Section section) {
        if (null == section) {
            return;
        }
        if (section.getNotifier() != null) {
            throw new IllegalStateException("Section is already has a parent!");
        }
        this.nestedSection.addSection(section);
    }

    public void clearAllSelections() {
        this.nestedSection.clearAllSelections();
    }

    public void collapseAllItems() {
        this.nestedSection.collapseAllItems();
    }

    public void collapseAllSections() {
        this.nestedSection.collapseAllSections();
    }

    public RecyclerView.ItemDecoration getItemDecoration() {
        return this.decorationDelegate;
    }

    public ItemTouchHelper getItemTouchHelper() {
        if (null == this.itemTouchHelper) {
            ItemTouchCallback itemTouchCallback = new ItemTouchCallback(this);
            this.itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)itemTouchCallback);
        }
        return this.itemTouchHelper;
    }

    public int getPositionType(RecyclerView parent, int adapterPosition) {
        int positionType = this.positionTypeCache.get(adapterPosition, -1);
        if (positionType == -1) {
            positionType = this.nestedSection.getPositionType(adapterPosition, adapterPosition, parent.getLayoutManager());
            this.positionTypeCache.append(adapterPosition, positionType);
        }
        return positionType;
    }

    public SectionPositionType getSectionPositionType(int adapterPosition) {
        return this.nestedSection.getSectionPositionType(adapterPosition);
    }

    public GridLayoutManager.SpanSizeLookup getSpanSizeLookup() {
        return this.spanSizeLookup;
    }

    public void registerItemBinders(ItemBinder ... itemBinders) {
        Collections.addAll(this.itemBinders, itemBinders);
    }

    public void removeAllSections() {
        int previousCount = this.getItemCount();
        this.nestedSection.removeAllSections();
        this.onDataSetChanged();
        this.notifier.notifySectionRangeRemoved(null, 0, previousCount);
    }

    public void setExpansionMode(@NonNull Mode expansionMode) {
        if (expansionMode == Mode.INHERIT) {
            return;
        }
        this.nestedSection.setExpansionMode(expansionMode);
    }

    public void setInfiniteLoadingHelper(@NonNull InfiniteLoadingHelper infiniteLoadingHelper) {
        this.registerItemBinders(infiniteLoadingHelper.getItemBinder());
        ItemSection<String> itemSection = new ItemSection<String>("LoadingItem");
        this.addSection(itemSection);
        infiniteLoadingHelper.setFooterSection(itemSection);
    }

    public void setSectionExpansionMode(Mode sectionExpansionMode) {
        if (sectionExpansionMode == Mode.INHERIT) {
            return;
        }
        this.nestedSection.setSectionExpansionMode(sectionExpansionMode);
    }

    public void setSelectionMode(Mode selectionMode) {
        if (selectionMode == Mode.INHERIT) {
            return;
        }
        this.nestedSection.setSelectionMode(selectionMode);
    }

    public void setSpanCount(int spanCount) {
        this.spanCount = spanCount;
        this.spanSizeCache.clear();
    }

    public void startActionMode() {
        this.isInActionMode = true;
    }

    public void stopActionMode() {
        this.isInActionMode = false;
    }

    public void unRegisterAllItemBinders() {
        this.itemBinders.clear();
        this.onDataSetChanged();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final int getSpanSize(int adapterPosition) {
        int calculatedSpanSize = this.spanSizeCache.get(adapterPosition, -1);
        if (calculatedSpanSize == -1) {
            int sectionSpanCount = this.getSectionSpanCount(adapterPosition);
            int spanSize = this.getItemBinder(adapterPosition).getSpanSize(sectionSpanCount);
            calculatedSpanSize = spanSize * this.spanCount / sectionSpanCount;
            this.spanSizeCache.append(adapterPosition, calculatedSpanSize);
        }
        return calculatedSpanSize;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void drawDecoration(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        this.drawSectionDecoration(canvas, parent, state, child, adapterPosition);
        this.drawItemDecoration(canvas, parent, state, child, adapterPosition);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void drawDecorationOver(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        this.drawSectionDecorationOver(canvas, parent, state, child, adapterPosition);
        this.drawItemDecorationOver(canvas, parent, state, child, adapterPosition);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void getDecorationOffset(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, int adapterPosition) {
        this.applySectionDecorationOffset(outRect, view, parent, state, adapterPosition);
        this.applyBinderDecorationOffset(outRect, view, parent, state, adapterPosition);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onItemDismiss(int adapterPosition) {
        this.nestedSection.onItemDismiss(adapterPosition);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onMove(int initialPosition, int targetPosition) {
        if (initialPosition == -1 || initialPosition == targetPosition) {
            return;
        }
        if (this.nestedSection.move(initialPosition, targetPosition - initialPosition)) {
            this.notifier.notifySectionItemMoved(this.nestedSection, initialPosition, targetPosition);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public final ItemViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return this.itemBinders.get(viewType).createViewHolder(parent, this);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onBindViewHolder(@NonNull ItemViewHolder holder, int adapterPosition) {
        this.onBindViewHolder(holder, adapterPosition, new ArrayList<Object>());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onBindViewHolder(ItemViewHolder holder, int adapterPosition, @NonNull List<Object> payloads) {
        ItemBinder itemBinder = this.itemBinders.get(holder.getItemViewType());
        holder.setItem(this.getItem(adapterPosition));
        if (payloads.size() == 0) {
            itemBinder.bindViewHolder(holder, holder.getItem());
        } else {
            itemBinder.bindViewHolder(holder, holder.getItem(), payloads);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final int getItemViewType(int adapterPosition) {
        int viewType = this.viewTypeCache.get(adapterPosition, -1);
        if (viewType == -1) {
            Object recyclerItem = this.getItem(adapterPosition);
            viewType = this.getItemBinderPositionForItem(recyclerItem);
            this.viewTypeCache.append(adapterPosition, viewType);
        }
        return viewType;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final int getItemCount() {
        return this.nestedSection.getCount();
    }

    boolean isSectionExpanded(int adapterPosition) {
        return this.nestedSection.isSectionExpanded(adapterPosition);
    }

    void onItemClicked(int adapterPosition) {
        this.nestedSection.onItemClicked(adapterPosition);
    }

    boolean isAdapterInActionMode() {
        return this.isInActionMode;
    }

    boolean isItemExpanded(int adapterPosition) {
        return this.nestedSection.isItemExpanded(adapterPosition);
    }

    boolean isItemSelected(int adapterPosition) {
        return this.nestedSection.isItemSelected(adapterPosition);
    }

    void onSectionExpansionToggled(int adapterPosition) {
        this.nestedSection.onSectionExpansionToggled(adapterPosition, Mode.MULTIPLE);
    }

    void onItemExpansionToggled(int adapterPosition) {
        this.nestedSection.onItemExpansionToggled(adapterPosition, Mode.MULTIPLE);
    }

    void onItemSelectionToggled(int adapterPosition) {
        this.nestedSection.onItemSelectionToggled(adapterPosition, Mode.MULTIPLE);
    }

    void onStartDrag(ItemViewHolder itemViewHolder) {
        if (null != this.itemTouchHelper) {
            this.itemTouchHelper.startDrag((RecyclerView.ViewHolder)itemViewHolder);
        }
    }

    void onDataSetChanged() {
        this.spanSizeLookup.clearCache();
        this.positionTypeCache.clear();
        this.spanSizeCache.clear();
        this.viewTypeCache.clear();
    }

    void notifyAdapterItemMoved(int fromPosition, int toPosition) {
        this.notifyItemMoved(fromPosition, toPosition);
    }

    void notifyAdapterRangeChanged(int positionStart, int itemCount, Object payload) {
        this.notifyItemRangeChanged(positionStart, itemCount, payload);
    }

    void notifyAdapterRangeInserted(int positionStart, int itemCount) {
        this.notifyItemRangeInserted(positionStart, itemCount);
    }

    void notifyAdapterRangeRemoved(int positionStart, int itemCount) {
        this.notifyItemRangeRemoved(positionStart, itemCount);
    }

    private void applyBinderDecorationOffset(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, int adapterPosition) {
        this.getItemBinder(adapterPosition).getItemOffsets(outRect, view, parent, state, adapterPosition);
    }

    private void applySectionDecorationOffset(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, int adapterPosition) {
        this.nestedSection.getChildSectionOffsets(adapterPosition, outRect, view, parent, state, adapterPosition);
    }

    private void drawItemDecoration(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        this.getItemBinder(adapterPosition).drawItemDecoration(canvas, parent, state, child, adapterPosition);
    }

    private void drawItemDecorationOver(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        this.getItemBinder(adapterPosition).drawItemDecorationOver(canvas, parent, state, child, adapterPosition);
    }

    private void drawSectionDecoration(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        this.nestedSection.drawChildSectionDecoration(adapterPosition, canvas, parent, state, child, adapterPosition);
    }

    private void drawSectionDecorationOver(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state, View child, int adapterPosition) {
        this.nestedSection.drawChildSectionDecorationOver(adapterPosition, canvas, parent, state, child, adapterPosition);
    }

    private ItemBinder getItemBinder(int adapterPosition) {
        return this.itemBinders.get(this.getItemViewType(adapterPosition));
    }

    private int getItemBinderPositionForItem(Object recyclerItem) {
        int binderPosition = 0;
        for (ItemBinder itemBinder : this.itemBinders) {
            if (itemBinder.canBindData(recyclerItem)) {
                return binderPosition;
            }
            ++binderPosition;
        }
        throw new IllegalStateException("ItemBinder not found for position. Item = " + recyclerItem);
    }

    @NonNull
    private Object getItem(int adapterPosition) {
        return this.nestedSection.getItem(adapterPosition);
    }

    private int getSectionSpanCount(int adapterPosition) {
        return this.nestedSection.getMaxSpanCount(adapterPosition, this.spanCount);
    }
}

