/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.parser;

import de.uniks.networkparser.parser.JavaFile;
import de.uniks.networkparser.parser.SymTabEntry;

public class JavaParser {
    private boolean fileBodyHasChanged = false;

    public SymTabEntry parse(CharSequence fileBody) {
        JavaFile javaFile = new JavaFile(fileBody);
        if (javaFile.currentTokenEquals("package")) {
            this.parsePackageDecl(javaFile);
        }
        while (javaFile.currentTokenEquals("import")) {
            this.parseImport(javaFile);
        }
        this.parseClassDecl();
        return javaFile.getRoot();
    }

    private void parseImport(JavaFile javaFile) {
        SymTabEntry nextEntity = javaFile.startNextSymTab("import");
        javaFile.nextToken();
        String modifier = this.parseModifiers(javaFile);
        nextEntity.add(modifier);
        this.parseQualifiedName(javaFile, nextEntity);
        if (javaFile.currentKindEquals('*')) {
            javaFile.skip('*');
        }
        javaFile.skip(';');
    }

    private String parseModifiers(JavaFile javaFile) {
        StringBuilder result = new StringBuilder();
        String modifiers = " public protected private static abstract final native synchronized transient volatile strictfp ";
        while (modifiers.indexOf(" " + javaFile.currentWord() + " ") >= 0) {
            result.append(javaFile.currentWord());
            result.append(" ");
            javaFile.nextToken();
        }
        return result.toString();
    }

    private void parsePackageDecl(JavaFile javaFile) {
        SymTabEntry nextEntity = javaFile.startNextSymTab("package");
        this.parseQualifiedName(javaFile, nextEntity);
        javaFile.addCurrentCharacter(';', nextEntity);
        javaFile.addNewLine(nextEntity);
    }

    private void parseClassDecl() {
    }

    private CharSequence parseQualifiedName(JavaFile javaFile, SymTabEntry nextEntity) {
        javaFile.nextToken();
        javaFile.nextToken();
        while (javaFile.currentKindEquals('.') && !javaFile.lookAheadKindEquals('.') && !javaFile.currentKindEquals('\u0000')) {
            javaFile.skip(".");
            javaFile.nextToken();
        }
        return javaFile.finishParse(nextEntity);
    }

    public boolean isFileBodyHasChanged() {
        return this.fileBodyHasChanged;
    }

    public boolean setFileBodyHasChanged(boolean value) {
        if (value != this.fileBodyHasChanged) {
            this.fileBodyHasChanged = value;
            return true;
        }
        return false;
    }
}

