/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.UpdateListener;

public class GraphPatternChange
implements UpdateListener,
SendableEntityCreator {
    public static final String OLD = "oldValue";
    public static final String NEW = "newValue";
    public static final String PROPERTY = "property";
    private String property;
    private Object oldValue;
    private Object newValue;

    @Override
    public boolean update(Object evt) {
        return true;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public GraphPatternChange withOldValue(Object value) {
        this.oldValue = value;
        return this;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public GraphPatternChange withProperty(String value) {
        this.property = value;
        return this;
    }

    public String getProperty() {
        return this.property;
    }

    public GraphPatternChange withNewValue(Object value) {
        this.newValue = value;
        return this;
    }

    @Override
    public String[] getProperties() {
        return new String[]{PROPERTY, OLD, NEW};
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new GraphPatternChange();
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (PROPERTY.equalsIgnoreCase(attribute)) {
            return ((GraphPatternChange)entity).getProperty();
        }
        if (OLD.equalsIgnoreCase(attribute)) {
            return ((GraphPatternChange)entity).getOldValue();
        }
        if (NEW.equalsIgnoreCase(attribute)) {
            return ((GraphPatternChange)entity).getNewValue();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (PROPERTY.equalsIgnoreCase(attribute)) {
            ((GraphPatternChange)entity).withProperty("" + value);
            return true;
        }
        if (OLD.equalsIgnoreCase(attribute)) {
            ((GraphPatternChange)entity).withOldValue(value);
            return true;
        }
        if (NEW.equalsIgnoreCase(attribute)) {
            ((GraphPatternChange)entity).withNewValue(value);
            return true;
        }
        return false;
    }

    public static GraphPatternChange createCreate(Object newValue) {
        return new GraphPatternChange().withNewValue(newValue);
    }

    public static GraphPatternChange createCreate(String property, Object newValue) {
        return new GraphPatternChange().withProperty(property).withNewValue(newValue);
    }

    public static GraphPatternChange createChange(Object oldValue, Object newValue) {
        return new GraphPatternChange().withOldValue(oldValue).withNewValue(newValue);
    }

    public static GraphPatternChange createChange(String property, Object oldValue, Object newValue) {
        return new GraphPatternChange().withProperty(property).withOldValue(oldValue).withNewValue(newValue);
    }

    public static GraphPatternChange createDelete(Object oldValue) {
        return new GraphPatternChange().withOldValue(oldValue);
    }

    public static GraphPatternChange createDelete(String property, Object oldValue) {
        return new GraphPatternChange().withProperty(property).withOldValue(oldValue);
    }
}

