/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes.qr;

import java.util.Arrays;

final class BitArray
implements Cloneable {
    private int[] bits;
    private int size;
    private int byteOffset;
    private int bitOffset;

    BitArray() {
        this.size = 0;
        this.bits = new int[1];
    }

    BitArray(int size) {
        this.size = size;
        this.bits = BitArray.makeArray(size);
    }

    BitArray(byte[] bytes) {
        if (bytes == null) {
            return;
        }
        this.size = bytes.length;
        this.bits = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.bits[i] = bytes[i];
        }
    }

    private BitArray(int[] bits, int size) {
        this.bits = bits;
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return (this.size + 7) / 8;
    }

    private void ensureCapacity(int size) {
        if (size > this.bits.length * 32) {
            int[] newBits = BitArray.makeArray(size);
            System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
            this.bits = newBits;
        }
    }

    public boolean get(int i) {
        return (this.bits[i / 32] & 1 << (i & 0x1F)) != 0;
    }

    public void set(int i) {
        int n = i / 32;
        this.bits[n] = this.bits[n] | 1 << (i & 0x1F);
    }

    void setBulk(int i, int newBits) {
        this.bits[i / 32] = newBits;
    }

    public void clear() {
        int max = this.bits.length;
        for (int i = 0; i < max; ++i) {
            this.bits[i] = 0;
        }
    }

    void appendBit(boolean bit) {
        this.ensureCapacity(this.size + 1);
        if (bit) {
            int n = this.size / 32;
            this.bits[n] = this.bits[n] | 1 << (this.size & 0x1F);
        }
        ++this.size;
    }

    void appendBits(int value, int numBits) {
        if (numBits < 0 || numBits > 32) {
            throw new IllegalArgumentException("Num bits must be between 0 and 32");
        }
        this.ensureCapacity(this.size + numBits);
        for (int numBitsLeft = numBits; numBitsLeft > 0; --numBitsLeft) {
            this.appendBit((value >> numBitsLeft - 1 & 1) == 1);
        }
    }

    void appendBitArray(BitArray other) {
        int otherSize = other.size;
        this.ensureCapacity(this.size + otherSize);
        for (int i = 0; i < otherSize; ++i) {
            this.appendBit(other.get(i));
        }
    }

    void xor(BitArray other) {
        if (this.bits.length != other.bits.length) {
            throw new IllegalArgumentException("Sizes don't match");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ other.bits[i];
        }
    }

    void toBytes(int bitOffset, byte[] array, int offset, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            int theByte = 0;
            for (int j = 0; j < 8; ++j) {
                if (this.get(bitOffset)) {
                    theByte |= 1 << 7 - j;
                }
                ++bitOffset;
            }
            array[offset + i] = (byte)theByte;
        }
    }

    int[] getBitArray() {
        return this.bits;
    }

    void reverse() {
        int[] newBits = new int[this.bits.length];
        int len = (this.size - 1) / 32;
        int oldBitsLen = len + 1;
        for (int i = 0; i < oldBitsLen; ++i) {
            long x = this.bits[i];
            x = x >> 1 & 0x55555555L | (x & 0x55555555L) << 1;
            x = x >> 2 & 0x33333333L | (x & 0x33333333L) << 2;
            x = x >> 4 & 0xF0F0F0FL | (x & 0xF0F0F0FL) << 4;
            x = x >> 8 & 0xFF00FFL | (x & 0xFF00FFL) << 8;
            x = x >> 16 & 0xFFFFL | (x & 0xFFFFL) << 16;
            newBits[len - i] = (byte)x;
        }
        if (this.size != oldBitsLen * 32) {
            int leftOffset = oldBitsLen * 32 - this.size;
            int mask = 1;
            for (int i = 0; i < 31 - leftOffset; ++i) {
                mask = mask << 1 | 1;
            }
            int currentInt = newBits[0] >> leftOffset & mask;
            for (int i = 1; i < oldBitsLen; ++i) {
                int nextInt = newBits[i];
                newBits[i - 1] = (byte)(currentInt |= nextInt << 32 - leftOffset);
                currentInt = nextInt >> leftOffset & mask;
            }
            newBits[oldBitsLen - 1] = (byte)currentInt;
        }
        this.bits = newBits;
    }

    private static int[] makeArray(int size) {
        return new int[(size + 31) / 32];
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitArray)) {
            return false;
        }
        BitArray other = (BitArray)o;
        return this.size == other.size && Arrays.equals(this.bits, other.bits);
    }

    public int hashCode() {
        return 31 * this.size + Arrays.hashCode(this.bits);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.size);
        for (int i = 0; i < this.size; ++i) {
            if ((i & 7) == 0) {
                result.append(' ');
            }
            result.append(this.get(i) ? (char)'X' : '.');
        }
        return result.toString();
    }

    public BitArray clone() {
        return new BitArray((int[])this.bits.clone(), this.size);
    }

    int available() {
        return 8 * (this.bits.length - this.byteOffset) - this.bitOffset;
    }

    int readBits(int numBits) {
        if (numBits < 1 || numBits > 32 || numBits > this.available()) {
            throw new IllegalArgumentException(String.valueOf(numBits));
        }
        int result = 0;
        if (this.bitOffset > 0) {
            int bitsLeft = 8 - this.bitOffset;
            int toRead = numBits < bitsLeft ? numBits : bitsLeft;
            int bitsToNotRead = bitsLeft - toRead;
            int mask = 255 >> 8 - toRead << bitsToNotRead;
            result = (this.bits[this.byteOffset] & mask) >> bitsToNotRead;
            numBits -= toRead;
            this.bitOffset += toRead;
            if (this.bitOffset == 8) {
                this.bitOffset = 0;
                ++this.byteOffset;
            }
        }
        if (numBits > 0) {
            while (numBits >= 8) {
                result = result << 8 | this.bits[this.byteOffset] & 0xFF;
                ++this.byteOffset;
                numBits -= 8;
            }
            if (numBits > 0) {
                int bitsToNotRead = 8 - numBits;
                int mask = 255 >> bitsToNotRead << bitsToNotRead;
                result = result << numBits | (this.bits[this.byteOffset] & mask) >> bitsToNotRead;
                this.bitOffset += numBits;
            }
        }
        return result;
    }
}

