/*
 * Decompiled with CFR 0.152.
 */
package de.timroes.axmlrpc;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import de.timroes.axmlrpc.XmlRpcResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class XmlRpcClient {
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"text/xml; charset=utf-8");
    private final URL url;
    private final OkHttpClient httpClient;

    public static XmlRpcClient forUrl(String url) throws MalformedURLException {
        return new XmlRpcClient(new URL(url));
    }

    public static XmlRpcClient forUrl(URL url) {
        return new XmlRpcClient(url);
    }

    private XmlRpcClient(URL url) {
        this.url = url;
        this.httpClient = new OkHttpClient();
    }

    public URL getUrl() {
        return this.url;
    }

    public MethodCall createCall(String method, Object ... params) {
        return new MethodCall(method, params);
    }

    public XmlRpcResponse call(String method, Object ... params) {
        return this.createCall(method, params).execute(this);
    }

    public XmlRpcResponse call(MethodCall call) {
        return call.execute(this);
    }

    private static class XmlRpcRequestBody {
        private final StringBuilder builder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><methodCall><methodName>");

        private XmlRpcRequestBody(String methodName) {
            this.builder.append(methodName).append("</methodName><params>");
        }

        public XmlRpcRequestBody param(Object param) {
            return this;
        }

        public String build() {
            return this.builder.append("</params></methodCall>").toString();
        }
    }

    public static class MethodCall {
        private final String method;
        private final Object[] params;

        private MethodCall(String method, Object[] params) {
            this.method = method;
            this.params = params;
        }

        private XmlRpcResponse execute(XmlRpcClient xmlRpcClient) {
            XmlRpcRequestBody body = new XmlRpcRequestBody(this.method);
            for (Object param : this.params) {
                body.param(param);
            }
            Request request = new Request.Builder().url(xmlRpcClient.url).post(RequestBody.create((MediaType)MEDIA_TYPE, (String)body.build())).build();
            try {
                Response response = xmlRpcClient.httpClient.newCall(request).execute();
                return new XmlRpcResponse(response.body().string());
            }
            catch (IOException ex) {
                Logger.getLogger(XmlRpcClient.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        public String getMethodName() {
            return this.method;
        }
    }
}

