/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.service;

import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.model.Role;
import de.terrestris.shogun2.model.User;
import de.terrestris.shogun2.model.token.RegistrationToken;
import de.terrestris.shogun2.model.token.UserToken;
import de.terrestris.shogun2.service.AbstractExtDirectCrudService;
import de.terrestris.shogun2.service.RegistrationTokenService;
import de.terrestris.shogun2.service.RoleService;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service(value="userService")
public class UserService
extends AbstractExtDirectCrudService<User> {
    private static final Logger LOG = Logger.getLogger(UserService.class);
    @Autowired
    private RegistrationTokenService registrationTokenService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    @Qualifier(value="userRole")
    private Role defaultUserRole;

    public User findByAccountName(String accountName) {
        SimpleExpression eqAccountName = Restrictions.eq((String)"accountName", (Object)accountName);
        User user = (User)this.dao.findByUniqueCriteria(new Criterion[]{eqAccountName});
        return user;
    }

    public User findByEmail(String email) {
        SimpleExpression eqEmail = Restrictions.eq((String)"email", (Object)email);
        User user = (User)this.dao.findByUniqueCriteria(new Criterion[]{eqEmail});
        return user;
    }

    public User registerUser(String email, String rawPassword, boolean isActive, HttpServletRequest request) throws Exception {
        User user = this.findByEmail(email);
        if (user != null) {
            String errorMessage = "User with eMail '" + email + "' already exists.";
            LOG.info((Object)errorMessage);
            throw new Exception(errorMessage);
        }
        user = new User();
        user.setEmail(email);
        user.setAccountName(email);
        user.setPassword(rawPassword);
        user.setActive(isActive);
        user = this.persistNewUser(user, true);
        this.registrationTokenService.sendRegistrationActivationMail(request, user);
        return user;
    }

    public void activateUser(String tokenValue) throws Exception {
        RegistrationToken token = (RegistrationToken)this.registrationTokenService.findByTokenValue(tokenValue);
        LOG.debug((Object)("Trying to activate user account with token: " + tokenValue));
        this.registrationTokenService.validateToken((UserToken)token);
        User user = token.getUser();
        user.setActive(true);
        String defaultRoleName = this.defaultUserRole.getName();
        Role persistedDefaultUserRole = this.roleService.findByRoleName(defaultRoleName);
        user.getRoles().add(persistedDefaultUserRole);
        this.dao.saveOrUpdate((PersistentObject)user);
        this.registrationTokenService.deleteTokenAfterActivation(token);
        LOG.info((Object)("The user '" + user.getAccountName() + "' has successfully been activated."));
    }

    public User persistNewUser(User user, boolean encryptPassword) {
        if (user.getId() != null) {
            return user;
        }
        if (encryptPassword) {
            user.setPassword(this.passwordEncoder.encode((CharSequence)user.getPassword()));
        }
        this.dao.saveOrUpdate((PersistentObject)user);
        return user;
    }

    public void updatePassword(User user, String rawPassword) throws Exception {
        if (user.getId() == null) {
            throw new Exception("The ID of the user object is null.");
        }
        user.setPassword(this.passwordEncoder.encode((CharSequence)rawPassword));
        this.dao.saveOrUpdate((PersistentObject)user);
    }

    public User getUserBySession() {
        User loggedInUser = (User)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        Integer id = loggedInUser.getId();
        return (User)this.dao.findById((Serializable)id);
    }

    public RegistrationTokenService getRegistrationTokenService() {
        return this.registrationTokenService;
    }

    public void setRegistrationTokenService(RegistrationTokenService registrationTokenService) {
        this.registrationTokenService = registrationTokenService;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public Role getDefaultUserRole() {
        return this.defaultUserRole;
    }

    public void setDefaultUserRole(Role defaultUserRole) {
        this.defaultUserRole = defaultUserRole;
    }
}

