/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.service;

import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.model.User;
import de.terrestris.shogun2.model.token.RegistrationToken;
import de.terrestris.shogun2.service.AbstractUserTokenService;
import de.terrestris.shogun2.util.application.Shogun2ContextUtil;
import de.terrestris.shogun2.util.mail.MailPublisher;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriUtils;

@Service(value="registrationTokenService")
public class RegistrationTokenService
extends AbstractUserTokenService<RegistrationToken> {
    private static final Logger LOG = Logger.getLogger(RegistrationTokenService.class);
    @Value(value="${login.accountActivationPath}")
    private String accountActivationPath;
    @Value(value="${login.registrationTokenExpirationTime}")
    private int registrationTokenExpirationTime;
    @Autowired
    private MailPublisher mailPublisher;
    @Autowired
    @Qualifier(value="registrationMailMessageTemplate")
    private SimpleMailMessage registrationMailMessageTemplate;

    public void sendRegistrationActivationMail(HttpServletRequest request, User user) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, URISyntaxException, UnsupportedEncodingException {
        RegistrationToken registrationToken = (RegistrationToken)this.getValidTokenForUser(user, this.registrationTokenExpirationTime);
        URI resetPasswordURI = this.createRegistrationActivationURI(request, registrationToken);
        SimpleMailMessage registrationActivationMsg = new SimpleMailMessage(this.registrationMailMessageTemplate);
        String email = user.getEmail();
        registrationActivationMsg.setTo(email);
        registrationActivationMsg.setText(String.format(registrationActivationMsg.getText(), UriUtils.decode((String)resetPasswordURI.toString(), (String)"UTF-8")));
        this.mailPublisher.sendMail(registrationActivationMsg);
    }

    private URI createRegistrationActivationURI(HttpServletRequest request, RegistrationToken registrationToken) throws URISyntaxException {
        URI appURI = Shogun2ContextUtil.getApplicationURIFromRequest((HttpServletRequest)request);
        URI tokenURI = new URIBuilder(appURI).setPath(appURI.getPath() + this.accountActivationPath).setParameter("token", registrationToken.getToken()).build();
        LOG.trace((Object)("Created the following URI for account activation: " + tokenURI));
        return tokenURI;
    }

    public void deleteTokenAfterActivation(RegistrationToken token) {
        this.dao.delete((PersistentObject)token);
        LOG.trace((Object)"The registration token has been deleted.");
    }

    public String getAccountActivationPath() {
        return this.accountActivationPath;
    }

    public void setAccountActivationPath(String accountActivationPath) {
        this.accountActivationPath = accountActivationPath;
    }

    public int getRegistrationTokenExpirationTime() {
        return this.registrationTokenExpirationTime;
    }

    public void setRegistrationTokenExpirationTime(int registrationTokenExpirationTime) {
        this.registrationTokenExpirationTime = registrationTokenExpirationTime;
    }

    public MailPublisher getMailPublisher() {
        return this.mailPublisher;
    }

    public void setMailPublisher(MailPublisher mailPublisher) {
        this.mailPublisher = mailPublisher;
    }

    public SimpleMailMessage getRegistrationMailMessageTemplate() {
        return this.registrationMailMessageTemplate;
    }

    public void setRegistrationMailMessageTemplate(SimpleMailMessage registrationMailMessageTemplate) {
        this.registrationMailMessageTemplate = registrationMailMessageTemplate;
    }
}

