/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.service;

import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.model.User;
import de.terrestris.shogun2.model.token.PasswordResetToken;
import de.terrestris.shogun2.model.token.UserToken;
import de.terrestris.shogun2.service.AbstractUserTokenService;
import de.terrestris.shogun2.service.UserService;
import de.terrestris.shogun2.util.application.Shogun2ContextUtil;
import de.terrestris.shogun2.util.mail.MailPublisher;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriUtils;

@Service(value="passwordResetTokenService")
public class PasswordResetTokenService
extends AbstractUserTokenService<PasswordResetToken> {
    private static final Logger LOG = Logger.getLogger(PasswordResetTokenService.class);
    @Autowired
    private UserService userService;
    @Autowired
    private MailPublisher mailPublisher;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    @Qualifier(value="resetPasswordMailMessageTemplate")
    private SimpleMailMessage resetPasswordMailMessageTemplate;
    @Autowired
    private String changePasswordPath;

    public void sendResetPasswordMail(HttpServletRequest request, String email) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, URISyntaxException, UnsupportedEncodingException {
        User user = this.userService.findByEmail(email);
        if (user == null) {
            throw new UsernameNotFoundException("Could not find user with email: '" + email + "'");
        }
        PasswordResetToken resetPasswordToken = (PasswordResetToken)this.getValidTokenForUser(user, null);
        URI resetPasswordURI = this.createResetPasswordURI(request, resetPasswordToken);
        SimpleMailMessage resetPwdMsg = new SimpleMailMessage(this.resetPasswordMailMessageTemplate);
        resetPwdMsg.setTo(email);
        resetPwdMsg.setText(String.format(resetPwdMsg.getText(), user.getFirstName(), user.getLastName(), UriUtils.decode((String)resetPasswordURI.toString(), (String)"UTF-8")));
        this.mailPublisher.sendMail(resetPwdMsg);
    }

    public void validateTokenAndUpdatePassword(String rawPassword, String token) throws Exception {
        PasswordResetToken passwordResetToken = (PasswordResetToken)this.findByTokenValue(token);
        this.validateToken((UserToken)passwordResetToken);
        User user = passwordResetToken.getUser();
        this.userService.updatePassword(user, rawPassword);
        this.dao.delete((PersistentObject)passwordResetToken);
        LOG.trace((Object)"Deleted the token.");
        LOG.debug((Object)"Successfully updated the password.");
    }

    private URI createResetPasswordURI(HttpServletRequest request, PasswordResetToken resetPasswordToken) throws URISyntaxException {
        URI appURI = Shogun2ContextUtil.getApplicationURIFromRequest((HttpServletRequest)request);
        URI tokenURI = new URIBuilder(appURI).setPath(appURI.getPath() + this.changePasswordPath).setParameter("token", resetPasswordToken.getToken()).build();
        return tokenURI;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public MailPublisher getMailPublisher() {
        return this.mailPublisher;
    }

    public void setMailPublisher(MailPublisher mailPublisher) {
        this.mailPublisher = mailPublisher;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public SimpleMailMessage getResetPasswordMailMessageTemplate() {
        return this.resetPasswordMailMessageTemplate;
    }

    public void setResetPasswordMailMessageTemplate(SimpleMailMessage resetPasswordMailMessageTemplate) {
        this.resetPasswordMailMessageTemplate = resetPasswordMailMessageTemplate;
    }

    public String getChangePasswordPath() {
        return this.changePasswordPath;
    }

    public void setChangePasswordPath(String changePasswordPath) {
        this.changePasswordPath = changePasswordPath;
    }
}

