/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.service;

import de.terrestris.shogun2.model.User;
import de.terrestris.shogun2.model.token.UserToken;
import de.terrestris.shogun2.service.AbstractCrudService;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.joda.time.DateTime;

public abstract class AbstractUserTokenService<E extends UserToken>
extends AbstractCrudService<E> {
    private static final Logger LOG = Logger.getLogger(AbstractUserTokenService.class);
    private static final int EXPIRY_THRESHOLD_MINUTES = 5;

    public E findByUser(User user) {
        SimpleExpression eqUser = Restrictions.eq((String)"user", (Object)user);
        UserToken userToken = (UserToken)this.dao.findByUniqueCriteria(new Criterion[]{eqUser});
        return (E)userToken;
    }

    public E findByTokenValue(String token) {
        SimpleExpression criteria = Restrictions.eq((String)"token", (Object)token);
        UserToken userToken = (UserToken)this.dao.findByUniqueCriteria(new Criterion[]{criteria});
        return (E)userToken;
    }

    protected void validateToken(UserToken userToken) throws Exception {
        if (userToken == null) {
            throw new Exception("The provided token does not exist.");
        }
        DateTime expirationDate = (DateTime)userToken.getExpirationDate();
        String tokenValue = userToken.getToken();
        if (expirationDate.isBeforeNow()) {
            throw new Exception("The token '" + tokenValue + "' expired on '" + expirationDate + "'");
        }
        if (userToken.getUser() == null) {
            throw new Exception("There is no user associated with this token.");
        }
    }

    protected E getValidTokenForUser(User user, Integer expirationTimeInMinutes) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        E userToken = this.findByUser(user);
        if (userToken != null) {
            if (userToken.expiresWithin(5)) {
                LOG.debug((Object)"User already has an expired token (or at least a token that expires within the next 5 minutes). This token will be deleted.");
                this.dao.delete(userToken);
            } else {
                LOG.debug((Object)("Returning existing token for user '" + user.getAccountName() + "'"));
                return userToken;
            }
        }
        userToken = this.buildConcreteUserTokenInstance(user, expirationTimeInMinutes);
        this.dao.saveOrUpdate(userToken);
        String tokenType = userToken.getClass().getSimpleName();
        LOG.debug((Object)("Successfully created a user token of type '" + tokenType + "' for user '" + user.getAccountName() + "'"));
        return userToken;
    }

    private E buildConcreteUserTokenInstance(User user, Integer expirationTimeInMinutes) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        UserToken concreteInstance;
        Class concreteUserTokenClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        if (expirationTimeInMinutes == null) {
            Constructor c = concreteUserTokenClass.getConstructor(User.class);
            concreteInstance = (UserToken)c.newInstance(user);
        } else {
            Constructor c = concreteUserTokenClass.getConstructor(User.class, Integer.TYPE);
            concreteInstance = (UserToken)c.newInstance(user, expirationTimeInMinutes);
        }
        return (E)concreteInstance;
    }
}

