/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.service;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreReadRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreResult;
import ch.ralscha.extdirectspring.bean.SortInfo;
import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.paging.PagingResult;
import de.terrestris.shogun2.service.AbstractCrudService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class AbstractExtDirectCrudService<E extends PersistentObject>
extends AbstractCrudService<E> {
    @Override
    @ExtDirectMethod
    public E saveOrUpdate(E e) {
        return super.saveOrUpdate(e);
    }

    @Override
    @ExtDirectMethod
    public E findById(Integer id) {
        return super.findById(id);
    }

    @Override
    @ExtDirectMethod
    public List<E> findAll() {
        return super.findAll();
    }

    @Override
    @ExtDirectMethod
    public void delete(E e) {
        super.delete(e);
    }

    @ExtDirectMethod(value=ExtDirectMethodType.STORE_READ)
    public ExtDirectStoreResult<E> findWithSortingAndPagingExtDirect(ExtDirectStoreReadRequest request) {
        Integer firstResult = request.getStart();
        Integer maxResults = request.getLimit();
        List sorters = request.getSorters();
        List<Order> hibernateSorters = this.buildHibernateSorters(sorters);
        PagingResult pagingResult = this.dao.findByCriteriaWithSortingAndPaging(firstResult, maxResults, hibernateSorters, new Criterion[0]);
        ExtDirectStoreResult extResult = new ExtDirectStoreResult(Integer.valueOf(pagingResult.getTotalCount().intValue()), (Collection)pagingResult.getResultList());
        return extResult;
    }

    @ExtDirectMethod(value=ExtDirectMethodType.FORM_LOAD)
    public E formLoadById(@RequestParam Integer id) {
        return super.findById(id);
    }

    @ExtDirectMethod(value=ExtDirectMethodType.STORE_MODIFY)
    public Collection<E> saveOrUpdateCollection(Collection<E> c) {
        ArrayList<PersistentObject> result = new ArrayList<PersistentObject>();
        for (PersistentObject e : c) {
            super.saveOrUpdate(e);
            result.add(e);
        }
        return result;
    }

    @ExtDirectMethod(value=ExtDirectMethodType.STORE_MODIFY)
    public void deleteCollection(Collection<E> c) {
        for (PersistentObject e : c) {
            super.delete(e);
        }
    }

    private List<Order> buildHibernateSorters(List<SortInfo> sorters) {
        ArrayList<Order> hibernateSorters = new ArrayList<Order>();
        for (SortInfo sortInfo : sorters) {
            String sortProperty = sortInfo.getProperty();
            Order sortInfoToAdd = null;
            switch (sortInfo.getDirection()) {
                case ASCENDING: {
                    sortInfoToAdd = Order.asc((String)sortProperty);
                    break;
                }
                case DESCENDING: {
                    sortInfoToAdd = Order.desc((String)sortProperty);
                    break;
                }
            }
            if (sortInfoToAdd == null) continue;
            hibernateSorters.add(sortInfoToAdd);
        }
        return hibernateSorters;
    }
}

