/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.service;

import de.terrestris.shogun2.model.PersistentObject;
import de.terrestris.shogun2.service.AbstractDaoService;
import java.io.Serializable;
import java.util.List;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;

public abstract class AbstractCrudService<E extends PersistentObject>
extends AbstractDaoService<E> {
    @PreAuthorize(value="isAuthenticated()")
    public E saveOrUpdate(E e) {
        this.dao.saveOrUpdate(e);
        return e;
    }

    @PostAuthorize(value="hasPermission(returnObject, 'READ')")
    public E findById(Integer id) {
        return (E)this.dao.findById((Serializable)id);
    }

    @PostAuthorize(value="hasPermission(returnObject, 'READ')")
    public E loadById(int id) {
        return (E)this.dao.loadById((Serializable)Integer.valueOf(id));
    }

    @PostFilter(value="hasPermission(filterObject, 'READ')")
    public List<E> findAll() {
        return this.dao.findAll();
    }

    @PreAuthorize(value="hasPermission(#e, 'DELETE')")
    public void delete(E e) {
        this.dao.delete(e);
    }
}

