/*
 * Decompiled with CFR 0.152.
 */
package de.terrestris.shogun2.model;

import ch.rasc.extclassgenerator.Model;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.terrestris.shogun2.model.Person;
import de.terrestris.shogun2.model.Role;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@Entity
@Table
@Model(value="shogun2.model.User", readMethod="userService.findWithSortingAndPagingExtDirect", createMethod="userService.saveOrUpdateCollection", updateMethod="userService.saveOrUpdateCollection", destroyMethod="userService.deleteCollection")
public class User
extends Person {
    private static final long serialVersionUID = 1L;
    @Column(unique=true)
    private String accountName;
    @Column
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String password;
    @Column
    private boolean active;
    @ManyToMany
    @JoinTable(joinColumns={@JoinColumn(name="USER_ID")}, inverseJoinColumns={@JoinColumn(name="ROLE_ID")})
    private Set<Role> roles = new HashSet<Role>();

    public User() {
    }

    public User(String firstName, String lastName, String accountName) {
        super(firstName, lastName);
        this.accountName = accountName;
    }

    public User(String firstName, String lastName, String accountName, String password) {
        super(firstName, lastName);
        this.accountName = accountName;
        this.password = password;
    }

    public User(String firstName, String lastName, String accountName, String password, boolean active) {
        super(firstName, lastName);
        this.accountName = accountName;
        this.password = password;
        this.active = active;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(23, 13).appendSuper(super.hashCode()).append((Object)this.getAccountName()).append((Object)this.getPassword()).append(this.isActive()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getAccountName(), (Object)other.getAccountName()).append((Object)this.getPassword(), (Object)other.getPassword()).append(this.isActive(), other.isActive()).isEquals();
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }
}

