/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dao.mongo.links;

import com.mongodb.DBObject;
import de.taimos.dao.mongo.links.AReferenceableEntity;
import de.taimos.dao.mongo.links.DocumentLink;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jongo.MongoCollection;
import org.jongo.ResultHandler;

public class DLinkQuery<T extends AReferenceableEntity<T>> {
    private Class<T> targetClass;
    private String labelField;

    public DLinkQuery(Class<T> targetClass, String labelField) {
        this.targetClass = targetClass;
        this.labelField = labelField;
    }

    public List<DocumentLink<T>> find(MongoCollection collection, String query, Object ... parameter) {
        ResultHandler handler = new ResultHandler<DocumentLink<T>>(){

            public DocumentLink<T> map(DBObject result) {
                if (!result.containsField("_id") || !result.containsField(DLinkQuery.this.labelField)) {
                    throw new RuntimeException("Fields missing to construct DocumentLink");
                }
                String id = result.get("_id").toString();
                String label = result.get(DLinkQuery.this.labelField).toString();
                return new DocumentLink(DLinkQuery.this.targetClass, id, label);
            }
        };
        Iterator it = collection.find(query, parameter).projection(String.format("{%s:1}", this.labelField)).map(handler).iterator();
        ArrayList<DocumentLink<T>> objects = new ArrayList<DocumentLink<T>>();
        while (it.hasNext()) {
            DocumentLink link = (DocumentLink)it.next();
            objects.add(link);
        }
        return objects;
    }
}

