/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.httputils;

import de.taimos.httputils.HTTPResponseCallback;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public final class HTTPRequest {
    private static final Executor DEFAULT_EXECUTOR = Executors.newCachedThreadPool();
    private final String url;
    private final Map<String, List<String>> headers = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, List<String>> queryParams = new ConcurrentHashMap<String, List<String>>();
    private final Map<String, String> pathParams = new ConcurrentHashMap<String, String>();
    private volatile Integer timeout;
    private volatile boolean followRedirect = true;
    private volatile String body = "";
    private volatile String userAgent = null;

    HTTPRequest(String url) {
        this.url = url;
    }

    public HTTPRequest header(String name, String value) {
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, new CopyOnWriteArrayList());
        }
        this.headers.get(name).add(value);
        return this;
    }

    public HTTPRequest queryParam(String name, String value) {
        if (!this.queryParams.containsKey(name)) {
            this.queryParams.put(name, new CopyOnWriteArrayList());
        }
        this.queryParams.get(name).add(value);
        return this;
    }

    public HTTPRequest pathParam(String name, String value) {
        this.pathParams.put(name, value);
        return this;
    }

    public HTTPRequest timeout(int newTimeout) {
        this.timeout = newTimeout;
        return this;
    }

    public HTTPRequest followRedirect(boolean follow) {
        this.followRedirect = follow;
        return this;
    }

    public HTTPRequest userAgent(String agent) {
        this.userAgent = agent;
        return this;
    }

    public HTTPRequest contentType(String type) {
        return this.header("Content-Type", type);
    }

    public HTTPRequest auth(String authString) {
        return this.header("Authorization", authString);
    }

    public HTTPRequest authBasic(String user, String password) {
        if (user == null || password == null) {
            throw new IllegalArgumentException("Neither user nor password can be null");
        }
        if (user.contains(":")) {
            throw new IllegalArgumentException("Colon not allowed in user according to RFC2617 Sec. 2");
        }
        String credentials = user + ":" + password;
        String auth = Base64.encodeBase64String((byte[])credentials.getBytes());
        return this.auth("Basic " + auth);
    }

    public HTTPRequest authBearer(String accessToken) {
        return this.auth("Bearer " + accessToken);
    }

    public HTTPRequest accept(String type) {
        return this.header("Accept", type);
    }

    public HTTPRequest body(String bodyString) {
        this.body = bodyString;
        return this;
    }

    public HTTPRequest form(Map<String, String> form) {
        StringBuilder formString = new StringBuilder();
        Iterator<Map.Entry<String, String>> parts = form.entrySet().iterator();
        if (parts.hasNext()) {
            Map.Entry<String, String> firstEntry = parts.next();
            formString.append(firstEntry.getKey());
            formString.append("=");
            formString.append(firstEntry.getValue());
            while (parts.hasNext()) {
                Map.Entry<String, String> entry = parts.next();
                formString.append("&");
                formString.append(entry.getKey());
                formString.append("=");
                formString.append(entry.getValue());
            }
        }
        return this.contentType("application/x-www-form-urlencoded").body(formString.toString());
    }

    public HttpResponse get() {
        return this.execute((HttpUriRequest)new HttpGet(this.buildURI()));
    }

    public HttpResponse put() {
        return this.execute((HttpUriRequest)new HttpPut(this.buildURI()));
    }

    public HttpResponse patch() {
        return this.execute((HttpUriRequest)new HttpPatch(this.buildURI()));
    }

    public HttpResponse post() {
        return this.execute((HttpUriRequest)new HttpPost(this.buildURI()));
    }

    public HttpResponse delete() {
        return this.execute((HttpUriRequest)new HttpDelete(this.buildURI()));
    }

    public HttpResponse options() {
        return this.execute((HttpUriRequest)new HttpOptions(this.buildURI()));
    }

    public HttpResponse head() {
        return this.execute((HttpUriRequest)new HttpHead(this.buildURI()));
    }

    public void getAsync(HTTPResponseCallback callback) {
        this.getAsync(DEFAULT_EXECUTOR, callback);
    }

    public void getAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, (HttpUriRequest)new HttpGet(this.buildURI()), callback);
    }

    public void putAsync(HTTPResponseCallback callback) {
        this.putAsync(DEFAULT_EXECUTOR, callback);
    }

    public void putAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, (HttpUriRequest)new HttpPut(this.buildURI()), callback);
    }

    public void patchAsync(HTTPResponseCallback callback) {
        this.patchAsync(DEFAULT_EXECUTOR, callback);
    }

    public void patchAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, (HttpUriRequest)new HttpPatch(this.buildURI()), callback);
    }

    public void postAsync(HTTPResponseCallback callback) {
        this.postAsync(DEFAULT_EXECUTOR, callback);
    }

    public void postAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, (HttpUriRequest)new HttpPost(this.buildURI()), callback);
    }

    public void deleteAsync(HTTPResponseCallback callback) {
        this.deleteAsync(DEFAULT_EXECUTOR, callback);
    }

    public void deleteAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, (HttpUriRequest)new HttpDelete(this.buildURI()), callback);
    }

    public void optionsAsync(HTTPResponseCallback callback) {
        this.optionsAsync(DEFAULT_EXECUTOR, callback);
    }

    public void optionsAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, (HttpUriRequest)new HttpOptions(this.buildURI()), callback);
    }

    public void headAsync(HTTPResponseCallback callback) {
        this.headAsync(DEFAULT_EXECUTOR, callback);
    }

    public void headAsync(Executor executor, HTTPResponseCallback callback) {
        this.executeAsync(executor, (HttpUriRequest)new HttpHead(this.buildURI()), callback);
    }

    private void executeAsync(Executor executor, final HttpUriRequest req, final HTTPResponseCallback cb) {
        Runnable execute = new Runnable(){

            @Override
            public void run() {
                HttpResponse res;
                try {
                    res = HTTPRequest.this.execute(req);
                }
                catch (Exception e) {
                    cb.fail(e);
                    return;
                }
                cb.response(res);
            }
        };
        executor.execute(execute);
    }

    private HttpResponse execute(HttpUriRequest req) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        RequestConfig.Builder reqConfig = RequestConfig.custom();
        if (this.timeout != null) {
            reqConfig.setConnectTimeout(this.timeout.intValue());
        }
        reqConfig.setRedirectsEnabled(this.followRedirect);
        builder.setDefaultRequestConfig(reqConfig.build());
        if (this.userAgent != null && !this.userAgent.isEmpty()) {
            builder.setUserAgent(this.userAgent);
        }
        try {
            CloseableHttpClient httpclient = builder.build();
            if (req instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase entityBase = (HttpEntityEnclosingRequestBase)req;
                entityBase.setEntity((HttpEntity)new StringEntity(this.body, "UTF-8"));
            }
            Set<Map.Entry<String, List<String>>> entrySet = this.headers.entrySet();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                List<String> list = entry.getValue();
                for (String string : list) {
                    req.addHeader(entry.getKey(), string);
                }
            }
            CloseableHttpResponse response = httpclient.execute(req);
            return response;
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private URI buildURI() {
        try {
            String u = this.url;
            for (Map.Entry<String, String> pathEntry : this.pathParams.entrySet()) {
                u = u.replace("{" + pathEntry.getKey() + "}", pathEntry.getValue());
            }
            URIBuilder builder = new URIBuilder(u);
            Set<Map.Entry<String, List<String>>> entrySet = this.queryParams.entrySet();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                List<String> list = entry.getValue();
                for (String string : list) {
                    builder.addParameter(entry.getKey(), string);
                }
            }
            URI uri = builder.build();
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URI", e);
        }
    }
}

