/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.template.xdocreport;

import de.taimos.dvalin.template.velocity.tools.DateTool;
import fr.opensagres.xdocreport.converter.ConverterTypeTo;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    public void generatePDF(String template, Map<String, Object> contextMap, OutputStream out) {
        try {
            InputStream in = ReportService.class.getResourceAsStream("/xdocreport/" + template);
            IXDocReport report = XDocReportRegistry.getRegistry().loadReport(in, TemplateEngineKind.Velocity);
            IContext context = report.createContext();
            context.putMap(contextMap);
            context.put("dateTool", (Object)new DateTool());
            report.convert(context, Options.getTo((ConverterTypeTo)ConverterTypeTo.PDF), out);
        }
        catch (XDocReportException | IOException e) {
            throw new RuntimeException("Error creating PDF", e);
        }
    }
}

