/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.template.velocity;

import com.google.common.base.Preconditions;
import de.taimos.dvalin.template.velocity.ITemplateResolver;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.velocity.VelocityEngineFactoryBean;
import org.springframework.ui.velocity.VelocityEngineUtils;

@Component
public class VelocityTemplateResolver
implements ITemplateResolver {
    @Autowired
    private VelocityEngineFactoryBean velocityEngineFactory;

    @Override
    public String resolveTemplate(String location, Map<String, Object> context) {
        Preconditions.checkArgument((location != null && !location.isEmpty() ? 1 : 0) != 0);
        try {
            VelocityEngine engine = this.velocityEngineFactory.createVelocityEngine();
            return VelocityEngineUtils.mergeTemplateIntoString((VelocityEngine)engine, (String)location, (String)"UTF-8", context);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String resolveRawTemplate(String template, Map<String, Object> context) {
        try {
            StringWriter result = new StringWriter();
            VelocityEngine engine = this.velocityEngineFactory.createVelocityEngine();
            VelocityContext velocityContext = new VelocityContext(context);
            engine.evaluate((Context)velocityContext, (Writer)result, "RawTemplate", template);
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

