/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.notification.push;

import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.CreatePlatformEndpointRequest;
import com.amazonaws.services.sns.model.CreatePlatformEndpointResult;
import com.amazonaws.services.sns.model.InvalidParameterException;
import com.amazonaws.services.sns.model.PublishRequest;
import de.taimos.daemon.spring.annotations.ProdComponent;
import de.taimos.dvalin.cloud.aws.AWSClient;
import de.taimos.dvalin.notification.push.PushMessageWrapper;
import de.taimos.dvalin.notification.push.PushService;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

@ProdComponent
public class AmazonSNSPushService
implements PushService {
    public static final Logger LOGGER = LoggerFactory.getLogger(AmazonSNSPushService.class);
    private static final String MESSAGE_STRUCTURE_JSON = "json";
    @AWSClient
    private AmazonSNSClient snsClient;
    @Value(value="${aws.pushApplicationARN}")
    private String applicationARN;

    public String registerDevice(String deviceToken, String userData) {
        try {
            LOGGER.info("Creating platform endpoint with device token {}", (Object)deviceToken);
            CreatePlatformEndpointRequest cpeReq = new CreatePlatformEndpointRequest().withPlatformApplicationArn(this.applicationARN).withToken(deviceToken);
            cpeReq.withCustomUserData(userData);
            CreatePlatformEndpointResult cpeRes = this.snsClient.createPlatformEndpoint(cpeReq);
            return cpeRes.getEndpointArn();
        }
        catch (InvalidParameterException ipe) {
            String message = ipe.getErrorMessage();
            Pattern p = Pattern.compile(".*Endpoint (arn:aws:sns[^ ]+) already exists with the same token.*");
            Matcher m = p.matcher(message);
            if (m.matches()) {
                return m.group(1);
            }
            throw ipe;
        }
    }

    public void sendNotification(String deviceId, PushMessageWrapper message) {
        try {
            PublishRequest req = new PublishRequest();
            req.setTargetArn(deviceId);
            req.setMessageStructure(MESSAGE_STRUCTURE_JSON);
            req.setMessage(message.toMessage());
            this.snsClient.publish(req);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

