/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.interconnect.core.spring.requestresponse;

import de.taimos.daemon.spring.annotations.TestComponent;
import de.taimos.dvalin.interconnect.core.daemon.IDaemonRequestResponse;
import de.taimos.dvalin.interconnect.core.spring.requestresponse.IRequestMock;
import de.taimos.dvalin.interconnect.model.FutureImpl;
import de.taimos.dvalin.interconnect.model.InterconnectObject;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.annotation.Autowired;

@TestComponent(value="requestResponse")
public class DaemonRequestResponseMock
implements IDaemonRequestResponse {
    private static final long DEFAULT_TIMEOUT = 10L;
    private static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private final Executor executor = Executors.newCachedThreadPool();
    @Autowired(required=false)
    private IRequestMock requestMock;

    public <R> R sync(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz) throws ExecutionException {
        return this.sync(uuid, queue, request, responseClazz, 10L, DEFAULT_TIMEOUT_UNIT);
    }

    public <R> R sync(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz, long timeout, TimeUnit unit) throws ExecutionException {
        try {
            return this.async(uuid, queue, request, responseClazz, timeout, unit).get(timeout, unit);
        }
        catch (TimeoutException e) {
            throw new ExecutionException((Throwable)new de.taimos.dvalin.interconnect.core.exceptions.TimeoutException(timeout));
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e);
        }
    }

    public <R> R sync(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz, long timeout, TimeUnit unit, boolean secure) throws ExecutionException {
        return this.sync(uuid, queue, request, responseClazz, timeout, unit);
    }

    public <R> Future<R> async(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz) {
        return this.async(uuid, queue, request, responseClazz, 10L, DEFAULT_TIMEOUT_UNIT);
    }

    public <R> Future<R> async(final UUID uuid, final String queue, final InterconnectObject request, final Class<R> responseClazz, long timeout, TimeUnit unit) {
        if (this.requestMock == null) {
            throw new UnsupportedOperationException("No requestMock");
        }
        final FutureImpl future = new FutureImpl();
        final IRequestMock requestMock = this.requestMock;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    future.set(requestMock.in(uuid, queue, request, responseClazz));
                }
                catch (Exception e) {
                    future.set(e);
                }
            }
        });
        return future;
    }

    public <R> Future<R> async(UUID uuid, String queue, InterconnectObject request, Class<R> responseClazz, long timeout, TimeUnit unit, boolean secure) {
        return this.async(uuid, queue, request, responseClazz, timeout, unit);
    }
}

