/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.dvalin.daemon;

import de.taimos.daemon.DaemonStarter;
import de.taimos.daemon.IDaemonLifecycleListener;
import de.taimos.daemon.log4j.Log4jLoggingConfigurer;
import de.taimos.daemon.properties.FilePropertyProvider;
import de.taimos.daemon.properties.IPropertyProvider;
import de.taimos.daemon.spring.SpringDaemonAdapter;
import de.taimos.dvalin.daemon.EnvPropertyProvider;
import de.taimos.dvalin.daemon.ISpringLifecycleListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.springframework.context.ApplicationContext;

public abstract class DvalinLifecycleAdapter
extends SpringDaemonAdapter {
    public static void start(String serviceName, DvalinLifecycleAdapter lifecycleAdapter) {
        lifecycleAdapter.setupLogging();
        DaemonStarter.startDaemon((String)serviceName, (IDaemonLifecycleListener)lifecycleAdapter);
    }

    protected void loadBasicProperties(Map<String, String> map) {
        super.loadBasicProperties(map);
        map.put("dns.ttl", "60");
    }

    public IPropertyProvider getPropertyProvider() {
        if (EnvPropertyProvider.isConfigured()) {
            return new EnvPropertyProvider();
        }
        return new FilePropertyProvider("dvalin.properties");
    }

    protected String getSpringResource() {
        return "spring/dvalin.xml";
    }

    protected void doAfterSpringStart() {
        for (ISpringLifecycleListener listener : this.getLifecycleListeners()) {
            listener.afterContextStart();
        }
        super.doAfterSpringStart();
    }

    protected void doBeforeSpringStop() {
        for (ISpringLifecycleListener listener : this.getLifecycleListeners()) {
            listener.beforeContextStop();
        }
        super.doBeforeSpringStop();
    }

    public void started() {
        for (ISpringLifecycleListener listener : this.getLifecycleListeners()) {
            listener.started();
        }
        super.started();
    }

    public void stopping() {
        for (ISpringLifecycleListener listener : this.getLifecycleListeners()) {
            listener.stopping();
        }
        super.stopping();
    }

    public void aborting() {
        for (ISpringLifecycleListener listener : this.getLifecycleListeners()) {
            listener.aborting();
        }
        super.aborting();
    }

    public void signalUSR2() {
        for (ISpringLifecycleListener listener : this.getLifecycleListeners()) {
            listener.signalUSR2();
        }
        super.signalUSR2();
    }

    protected void setupLogging() {
        Log4jLoggingConfigurer.setup();
    }

    private Collection<ISpringLifecycleListener> getLifecycleListeners() {
        Map map;
        ApplicationContext context = this.getContext();
        if (context != null && (map = context.getBeansOfType(ISpringLifecycleListener.class)) != null) {
            return map.values();
        }
        return Collections.EMPTY_LIST;
    }
}

