/*
 * Decompiled with CFR 0.152.
 */
package de.taimos.daemon.spring;

import de.taimos.daemon.DaemonLifecycleAdapter;
import de.taimos.daemon.DaemonStarter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public abstract class SpringDaemonAdapter
extends DaemonLifecycleAdapter {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final AtomicReference<AbstractXmlApplicationContext> context = new AtomicReference<Object>(null);
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public final void doStart() throws Exception {
        super.doStart();
        try {
            this.doBeforeSpringStart();
        }
        catch (Exception e) {
            throw new RuntimeException("Before spring failed", e);
        }
        Lock writeLock = this.rwLock.writeLock();
        AbstractXmlApplicationContext ctx = null;
        try {
            writeLock.lock();
            if (this.context.get() != null) {
                throw new RuntimeException("Already started");
            }
            ctx = this.createSpringContext();
            String[] profiles = System.getProperty("profiles", "prod").split(",");
            ctx.getEnvironment().setActiveProfiles(profiles);
            PropertySourcesPlaceholderConfigurer configurer = new PropertySourcesPlaceholderConfigurer();
            configurer.setProperties(DaemonStarter.getDaemonProperties());
            ctx.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)configurer);
            ctx.setConfigLocation(this.getSpringResource());
            ctx.refresh();
            if (ctx != null) {
                this.context.set(ctx);
            }
            writeLock.unlock();
        }
        catch (Exception e) {
            try {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (Exception e1) {
                        this.logger.warn("Failed to close context", (Throwable)e1);
                    }
                    ctx = null;
                }
                throw new RuntimeException("Spring context failed", e);
            }
            catch (Throwable throwable) {
                if (ctx != null) {
                    this.context.set(ctx);
                }
                writeLock.unlock();
                throw throwable;
            }
        }
        try {
            this.doAfterSpringStart();
        }
        catch (Exception e) {
            throw new RuntimeException("After spring failed", e);
        }
    }

    protected void doAfterSpringStart() {
    }

    protected void doBeforeSpringStart() {
    }

    protected void doAfterSpringStop() {
    }

    protected void doBeforeSpringStop() {
    }

    protected AbstractXmlApplicationContext createSpringContext() {
        return new ClassPathXmlApplicationContext();
    }

    protected String getSpringResource() {
        return "spring/beans.xml";
    }

    public final void doStop() throws Exception {
        try {
            this.doBeforeSpringStop();
        }
        catch (Exception e) {
            throw new RuntimeException("Before spring stop failed", e);
        }
        Lock writeLock = this.rwLock.writeLock();
        try {
            writeLock.lock();
            if (this.context.get() == null) {
                throw new RuntimeException("Not yet started");
            }
            this.context.get().stop();
            this.context.get().close();
            this.context.set(null);
        }
        catch (Exception e) {
            throw new RuntimeException("spring stop failed", e);
        }
        finally {
            writeLock.unlock();
        }
        try {
            this.doAfterSpringStop();
        }
        catch (Exception e) {
            throw new RuntimeException("After spring stop failed", e);
        }
        super.doStop();
    }

    public Map<String, String> loadProperties() {
        Map props = super.loadProperties();
        if (System.getProperty("servicePackage") == null) {
            props.put("servicePackage", ((Object)((Object)this)).getClass().getPackage().getName());
        }
        return props;
    }

    public final ApplicationContext getContext() {
        Lock readLock = this.rwLock.readLock();
        try {
            readLock.lock();
            ApplicationContext applicationContext = (ApplicationContext)this.context.get();
            return applicationContext;
        }
        finally {
            readLock.unlock();
        }
    }
}

