/*
 * Decompiled with CFR 0.152.
 */
package de.svenkubiak.mangooio.mongodb;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import io.mangoo.configuration.Config;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MongoDB {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDB.class);
    private static final int DEFAULT_MONGODB_PORT = 27017;
    private static final String DEFAULT_MORPHIA_PACKAGE = "MyMorphiaPackage";
    private static final String DEFAULT_MONGODB_NAME = "MyMongoDB";
    private static final String DEFAULT_MONGODB_HOST = "localhost";
    private static final String MONGODB_HOST = "mongodb.host";
    private static final String MONGODB_PORT = "mongodb.port";
    private static final String MONGODB_USER = "mongodb.user";
    private static final String MONGODB_PASS = "mongodb.pass";
    private static final String MONGODB_DBNAME = "mongodb.dbname";
    private static final String MONGODB_AUTHDB = "mongodb.authdb";
    private static final String MORPHIA_PACKAGE = "morphia.package";
    private static final String MORPHIA_INIT = "morphia.init";
    private Datastore datastore;
    private Morphia morphia;
    private MongoClient mongoClient;
    private Config config;

    @Inject
    public MongoDB(Config config) {
        this.config = config;
        this.connect();
        if (this.config.getBoolean(MORPHIA_INIT, false)) {
            this.morphify();
        }
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public Morphia getMorphia() {
        return this.morphia;
    }

    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    private void connect() {
        String string = this.config.getString(MONGODB_HOST, DEFAULT_MONGODB_HOST);
        int n = this.config.getInt(MONGODB_PORT, 27017);
        String string2 = this.config.getString(MONGODB_USER, null);
        String string3 = this.config.getString(MONGODB_PASS, null);
        String string4 = this.config.getString(MONGODB_AUTHDB);
        if (StringUtils.isNotBlank((CharSequence)string2) && StringUtils.isNotBlank((CharSequence)string3) && StringUtils.isNotBlank((CharSequence)string4)) {
            this.mongoClient = new MongoClient(new ServerAddress(string, n), Arrays.asList(MongoCredential.createScramSha1Credential((String)string2, (String)string4, (char[])string3.toCharArray())));
            LOG.info("Successfully created MongoClient @ {}:{} with authentication {}/*******", new Object[]{string, n, string2});
        } else {
            this.mongoClient = new MongoClient(string, n);
            LOG.info("Successfully created MongoClient @ {}:{}", (Object)string, (Object)n);
        }
    }

    private void morphify() {
        String string = this.config.getString(MORPHIA_PACKAGE, DEFAULT_MORPHIA_PACKAGE);
        String string2 = this.config.getString(MONGODB_DBNAME, DEFAULT_MONGODB_NAME);
        this.morphia = new Morphia().mapPackage(string);
        this.datastore = this.morphia.createDatastore(this.mongoClient, string2);
        LOG.info("Mapped Morphia models of package '" + string + "' and created Morphia Datastore to database '" + string2 + "'");
    }

    public void ensureIndexes(boolean bl) {
        this.datastore.ensureIndexes(bl);
    }

    public void ensureCaps() {
        this.datastore.ensureCaps();
    }

    public <T> T findById(Object object, Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to find an object by id, but given class is null");
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to find an object by id, but given id is null");
        return (T)this.datastore.get(clazz, object instanceof ObjectId ? object : new ObjectId(String.valueOf(object)));
    }

    public <T> List<T> findAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to get all morphia objects of a given object, but given object is null");
        return this.datastore.find(clazz).asList();
    }

    public <T> long countAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to count all a morphia objects of a given object, but given object is null");
        return this.datastore.find(clazz).countAll();
    }

    public void save(Object object) {
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to save a morphia object, but a given object is null");
        this.datastore.save(object);
    }

    public void delete(Object object) {
        Preconditions.checkNotNull((Object)object, (Object)"Tryed to delete a morphia object, but given object is null");
        this.datastore.delete(object);
    }

    public <T> void deleteAll(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Tryed to delete list of mapped morphia objects, but given class is null");
        this.datastore.delete(this.datastore.createQuery(clazz));
    }

    public void dropDatabase() {
        this.datastore.getDB().dropDatabase();
    }
}

