/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.eclipse.aether.util.graph.visitor;

import de.softwareforge.testing.maven.org.eclipse.aether.artifact.$Artifact;
import de.softwareforge.testing.maven.org.eclipse.aether.graph.$Dependency;
import de.softwareforge.testing.maven.org.eclipse.aether.graph.$DependencyNode;
import de.softwareforge.testing.maven.org.eclipse.aether.graph.$DependencyVisitor;
import de.softwareforge.testing.maven.org.eclipse.aether.util.artifact.$ArtifactIdUtils;
import de.softwareforge.testing.maven.org.eclipse.aether.util.graph.manager.$DependencyManagerUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class $DependencyGraphDumper
implements $DependencyVisitor {
    private final Consumer<String> consumer;
    private final List<ChildInfo> childInfos = new ArrayList<ChildInfo>();

    public $DependencyGraphDumper(Consumer<String> consumer) {
        this.consumer = Objects.requireNonNull(consumer);
    }

    @Override
    public boolean visitEnter($DependencyNode node) {
        this.consumer.accept(this.formatIndentation() + this.formatNode(node));
        this.childInfos.add(new ChildInfo(node.getChildren().size()));
        return true;
    }

    private String formatIndentation() {
        StringBuilder buffer = new StringBuilder(128);
        Iterator<ChildInfo> it = this.childInfos.iterator();
        while (it.hasNext()) {
            buffer.append(it.next().formatIndentation(!it.hasNext()));
        }
        return buffer.toString();
    }

    private String formatNode($DependencyNode node) {
        $DependencyNode winner;
        String premanaged;
        StringBuilder buffer = new StringBuilder(128);
        $Artifact a = node.getArtifact();
        $Dependency d = node.getDependency();
        buffer.append(a);
        if (d != null && d.getScope().length() > 0) {
            buffer.append(" [").append(d.getScope());
            if (d.isOptional()) {
                buffer.append(", optional");
            }
            buffer.append("]");
        }
        if ((premanaged = $DependencyManagerUtils.getPremanagedVersion(node)) != null && !premanaged.equals(a.getBaseVersion())) {
            buffer.append(" (version managed from ").append(premanaged).append(")");
        }
        if ((premanaged = $DependencyManagerUtils.getPremanagedScope(node)) != null && !premanaged.equals(d.getScope())) {
            buffer.append(" (scope managed from ").append(premanaged).append(")");
        }
        if ((winner = ($DependencyNode)node.getData().get("conflict.winner")) != null) {
            if ($ArtifactIdUtils.equalsId(a, winner.getArtifact())) {
                buffer.append(" (nearer exists)");
            } else {
                $Artifact w = winner.getArtifact();
                buffer.append(" (conflicts with ");
                if ($ArtifactIdUtils.toVersionlessId(a).equals($ArtifactIdUtils.toVersionlessId(w))) {
                    buffer.append(w.getVersion());
                } else {
                    buffer.append(w);
                }
                buffer.append(")");
            }
        }
        return buffer.toString();
    }

    @Override
    public boolean visitLeave($DependencyNode node) {
        if (!this.childInfos.isEmpty()) {
            this.childInfos.remove(this.childInfos.size() - 1);
        }
        if (!this.childInfos.isEmpty()) {
            ++this.childInfos.get((int)(this.childInfos.size() - 1)).index;
        }
        return true;
    }

    private static class ChildInfo {
        final int count;
        int index;

        ChildInfo(int count) {
            this.count = count;
        }

        public String formatIndentation(boolean end) {
            boolean last;
            boolean bl = last = this.index + 1 >= this.count;
            if (end) {
                return last ? "\\- " : "+- ";
            }
            return last ? "   " : "|  ";
        }
    }
}

