/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.eclipse.aether.internal.impl.filter;

import de.softwareforge.testing.maven.org.eclipse.aether.repository.$RemoteRepository;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.$ArtifactDownload;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.$ArtifactUpload;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.$MetadataDownload;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.$MetadataUpload;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.$RepositoryConnector;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.filter.$RemoteRepositoryFilter;
import de.softwareforge.testing.maven.org.eclipse.aether.transfer.$ArtifactNotFoundException;
import de.softwareforge.testing.maven.org.eclipse.aether.transfer.$MetadataNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public final class $FilteringRepositoryConnector
implements $RepositoryConnector {
    private final $RemoteRepository remoteRepository;
    private final $RepositoryConnector delegate;
    private final $RemoteRepositoryFilter remoteRepositoryFilter;

    public $FilteringRepositoryConnector($RemoteRepository remoteRepository, $RepositoryConnector delegate, $RemoteRepositoryFilter remoteRepositoryFilter) {
        this.remoteRepository = Objects.requireNonNull(remoteRepository);
        this.delegate = Objects.requireNonNull(delegate);
        this.remoteRepositoryFilter = Objects.requireNonNull(remoteRepositoryFilter);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void get(Collection<? extends $ArtifactDownload> artifactDownloads, Collection<? extends $MetadataDownload> metadataDownloads) {
        ArrayList<$ArtifactDownload> filteredArtifactDownloads = null;
        if (artifactDownloads != null && !artifactDownloads.isEmpty()) {
            filteredArtifactDownloads = new ArrayList<$ArtifactDownload>(artifactDownloads.size());
            for ($ArtifactDownload $ArtifactDownload : artifactDownloads) {
                $RemoteRepositoryFilter.Result result = this.remoteRepositoryFilter.acceptArtifact(this.remoteRepository, $ArtifactDownload.getArtifact());
                if (result.isAccepted()) {
                    filteredArtifactDownloads.add($ArtifactDownload);
                    continue;
                }
                $ArtifactDownload.setException(new $ArtifactNotFoundException($ArtifactDownload.getArtifact(), this.remoteRepository, result.reasoning()));
            }
        }
        ArrayList<$MetadataDownload> filteredMetadataDownloads = null;
        if (metadataDownloads != null && !metadataDownloads.isEmpty()) {
            filteredMetadataDownloads = new ArrayList<$MetadataDownload>(metadataDownloads.size());
            for ($MetadataDownload $MetadataDownload : metadataDownloads) {
                $RemoteRepositoryFilter.Result result = this.remoteRepositoryFilter.acceptMetadata(this.remoteRepository, $MetadataDownload.getMetadata());
                if (result.isAccepted()) {
                    filteredMetadataDownloads.add($MetadataDownload);
                    continue;
                }
                $MetadataDownload.setException(new $MetadataNotFoundException($MetadataDownload.getMetadata(), this.remoteRepository, result.reasoning()));
            }
        }
        this.delegate.get(filteredArtifactDownloads, filteredMetadataDownloads);
    }

    @Override
    public void put(Collection<? extends $ArtifactUpload> artifactUploads, Collection<? extends $MetadataUpload> metadataUploads) {
        this.delegate.put(artifactUploads, metadataUploads);
    }

    public String toString() {
        return "filtered(" + this.delegate.toString() + ")";
    }
}

