/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.eclipse.aether.internal.impl;

import de.softwareforge.testing.maven.javax.inject.;
import de.softwareforge.testing.maven.org.eclipse.aether.$RepositoryEvent;
import de.softwareforge.testing.maven.org.eclipse.aether.$RepositoryException;
import de.softwareforge.testing.maven.org.eclipse.aether.$RepositorySystemSession;
import de.softwareforge.testing.maven.org.eclipse.aether.$RequestTrace;
import de.softwareforge.testing.maven.org.eclipse.aether.$SyncContext;
import de.softwareforge.testing.maven.org.eclipse.aether.artifact.$Artifact;
import de.softwareforge.testing.maven.org.eclipse.aether.deployment.$DeployRequest;
import de.softwareforge.testing.maven.org.eclipse.aether.deployment.$DeployResult;
import de.softwareforge.testing.maven.org.eclipse.aether.deployment.$DeploymentException;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$Deployer;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$MetadataGenerator;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$MetadataGeneratorFactory;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$OfflineController;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$RemoteRepositoryManager;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$RepositoryConnectorProvider;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$RepositoryEventDispatcher;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$UpdateCheck;
import de.softwareforge.testing.maven.org.eclipse.aether.impl.$UpdateCheckManager;
import de.softwareforge.testing.maven.org.eclipse.aether.internal.impl.$PrioritizedComponent;
import de.softwareforge.testing.maven.org.eclipse.aether.internal.impl.$PrioritizedComponents;
import de.softwareforge.testing.maven.org.eclipse.aether.internal.impl.$SafeTransferListener;
import de.softwareforge.testing.maven.org.eclipse.aether.internal.impl.$Utils;
import de.softwareforge.testing.maven.org.eclipse.aether.metadata.$MergeableMetadata;
import de.softwareforge.testing.maven.org.eclipse.aether.metadata.$Metadata;
import de.softwareforge.testing.maven.org.eclipse.aether.repository.$LocalRepositoryManager;
import de.softwareforge.testing.maven.org.eclipse.aether.repository.$RemoteRepository;
import de.softwareforge.testing.maven.org.eclipse.aether.repository.$RepositoryPolicy;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.$ArtifactUpload;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.$MetadataDownload;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.$MetadataUpload;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.connector.$RepositoryConnector;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.io.$FileProcessor;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.locator.$Service;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.locator.$ServiceLocator;
import de.softwareforge.testing.maven.org.eclipse.aether.spi.synccontext.$SyncContextFactory;
import de.softwareforge.testing.maven.org.eclipse.aether.transfer.$ArtifactTransferException;
import de.softwareforge.testing.maven.org.eclipse.aether.transfer.$MetadataNotFoundException;
import de.softwareforge.testing.maven.org.eclipse.aether.transfer.$MetadataTransferException;
import de.softwareforge.testing.maven.org.eclipse.aether.transfer.$NoRepositoryConnectorException;
import de.softwareforge.testing.maven.org.eclipse.aether.transfer.$RepositoryOfflineException;
import de.softwareforge.testing.maven.org.eclipse.aether.transfer.$TransferCancelledException;
import de.softwareforge.testing.maven.org.eclipse.aether.transfer.$TransferEvent;
import de.softwareforge.testing.maven.org.eclipse.aether.transform.$FileTransformer;
import de.softwareforge.testing.maven.org.eclipse.aether.transform.$FileTransformerManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;

@.Singleton
@.Named
public class $DefaultDeployer
implements $Deployer,
$Service {
    private $FileProcessor fileProcessor;
    private $RepositoryEventDispatcher repositoryEventDispatcher;
    private $RepositoryConnectorProvider repositoryConnectorProvider;
    private $RemoteRepositoryManager remoteRepositoryManager;
    private $UpdateCheckManager updateCheckManager;
    private Collection<$MetadataGeneratorFactory> metadataFactories = new ArrayList<$MetadataGeneratorFactory>();
    private $SyncContextFactory syncContextFactory;
    private $OfflineController offlineController;

    @Deprecated
    public $DefaultDeployer() {
    }

    @.Inject
    public $DefaultDeployer($FileProcessor fileProcessor, $RepositoryEventDispatcher repositoryEventDispatcher, $RepositoryConnectorProvider repositoryConnectorProvider, $RemoteRepositoryManager remoteRepositoryManager, $UpdateCheckManager updateCheckManager, Set<$MetadataGeneratorFactory> metadataFactories, $SyncContextFactory syncContextFactory, $OfflineController offlineController) {
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setRepositoryConnectorProvider(repositoryConnectorProvider);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setUpdateCheckManager(updateCheckManager);
        this.setMetadataGeneratorFactories(metadataFactories);
        this.setSyncContextFactory(syncContextFactory);
        this.setOfflineController(offlineController);
    }

    @Override
    public void initService($ServiceLocator locator) {
        this.setFileProcessor(locator.getService($FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService($RepositoryEventDispatcher.class));
        this.setRepositoryConnectorProvider(locator.getService($RepositoryConnectorProvider.class));
        this.setRemoteRepositoryManager(locator.getService($RemoteRepositoryManager.class));
        this.setUpdateCheckManager(locator.getService($UpdateCheckManager.class));
        this.setMetadataGeneratorFactories(locator.getServices($MetadataGeneratorFactory.class));
        this.setSyncContextFactory(locator.getService($SyncContextFactory.class));
        this.setOfflineController(locator.getService($OfflineController.class));
    }

    public $DefaultDeployer setFileProcessor($FileProcessor fileProcessor) {
        this.fileProcessor = Objects.requireNonNull(fileProcessor, "file processor cannot be null");
        return this;
    }

    public $DefaultDeployer setRepositoryEventDispatcher($RepositoryEventDispatcher repositoryEventDispatcher) {
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repository event dispatcher cannot be null");
        return this;
    }

    public $DefaultDeployer setRepositoryConnectorProvider($RepositoryConnectorProvider repositoryConnectorProvider) {
        this.repositoryConnectorProvider = Objects.requireNonNull(repositoryConnectorProvider, "repository connector provider cannot be null");
        return this;
    }

    public $DefaultDeployer setRemoteRepositoryManager($RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository provider cannot be null");
        return this;
    }

    public $DefaultDeployer setUpdateCheckManager($UpdateCheckManager updateCheckManager) {
        this.updateCheckManager = Objects.requireNonNull(updateCheckManager, "update check manager cannot be null");
        return this;
    }

    public $DefaultDeployer addMetadataGeneratorFactory($MetadataGeneratorFactory factory) {
        this.metadataFactories.add(Objects.requireNonNull(factory, "metadata generator factory cannot be null"));
        return this;
    }

    public $DefaultDeployer setMetadataGeneratorFactories(Collection<$MetadataGeneratorFactory> metadataFactories) {
        this.metadataFactories = metadataFactories == null ? new ArrayList<$MetadataGeneratorFactory>() : metadataFactories;
        return this;
    }

    public $DefaultDeployer setSyncContextFactory($SyncContextFactory syncContextFactory) {
        this.syncContextFactory = Objects.requireNonNull(syncContextFactory, "sync context factory cannot be null");
        return this;
    }

    public $DefaultDeployer setOfflineController($OfflineController offlineController) {
        this.offlineController = Objects.requireNonNull(offlineController, "offline controller cannot be null");
        return this;
    }

    @Override
    public $DeployResult deploy($RepositorySystemSession session, $DeployRequest request) throws $DeploymentException {
        Objects.requireNonNull(session, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        try {
            $Utils.checkOffline(session, this.offlineController, request.getRepository());
        }
        catch ($RepositoryOfflineException e) {
            throw new $DeploymentException("Cannot deploy while " + request.getRepository().getId() + " (" + request.getRepository().getUrl() + ") is in offline mode", e);
        }
        try ($SyncContext syncContext = this.syncContextFactory.newInstance(session, true);){
            $DeployResult $DeployResult = this.deploy(syncContext, session, request);
            return $DeployResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private $DeployResult deploy($SyncContext syncContext, $RepositorySystemSession session, $DeployRequest request) throws $DeploymentException {
        $RepositoryConnector connector;
        $DeployResult result = new $DeployResult(request);
        $RequestTrace trace = $RequestTrace.newChild(request.getTrace(), request);
        $RemoteRepository repository = request.getRepository();
        try {
            connector = this.repositoryConnectorProvider.newRepositoryConnector(session, repository);
        }
        catch ($NoRepositoryConnectorException e) {
            throw new $DeploymentException("Failed to deploy artifacts/metadata: " + e.getMessage(), e);
        }
        try {
            List<? extends $MetadataGenerator> generators = this.getMetadataGenerators(session, request);
            $FileTransformerManager fileTransformerManager = session.getFileTransformerManager();
            ArrayList<$ArtifactUpload> artifactUploads = new ArrayList<$ArtifactUpload>();
            ArrayList<$MetadataUpload> metadataUploads = new ArrayList<$MetadataUpload>();
            IdentityHashMap processedMetadata = new IdentityHashMap();
            EventCatapult catapult = new EventCatapult(session, trace, repository, this.repositoryEventDispatcher);
            ArrayList<$Artifact> artifacts = new ArrayList<$Artifact>(request.getArtifacts());
            List<$Metadata> metadatas = $Utils.prepareMetadata(generators, artifacts);
            syncContext.acquire(artifacts, $Utils.combine(request.getMetadata(), metadatas));
            for ($Metadata $Metadata : metadatas) {
                this.upload(metadataUploads, session, $Metadata, repository, connector, catapult);
                processedMetadata.put($Metadata, null);
            }
            ListIterator<void> iterator = artifacts.listIterator();
            while (iterator.hasNext()) {
                void var17_21;
                $Artifact $Artifact = ($Artifact)iterator.next();
                for ($MetadataGenerator $MetadataGenerator : generators) {
                    $Artifact $Artifact2 = $MetadataGenerator.transformArtifact(($Artifact)var17_21);
                }
                iterator.set(var17_21);
                Collection<$FileTransformer> fileTransformers = fileTransformerManager.getTransformersForArtifact(($Artifact)var17_21);
                if (!fileTransformers.isEmpty()) {
                    for ($FileTransformer fileTransformer : fileTransformers) {
                        $Artifact targetArtifact = fileTransformer.transformArtifact(($Artifact)var17_21);
                        $ArtifactUpload upload = new $ArtifactUpload(targetArtifact, var17_21.getFile(), fileTransformer);
                        upload.setTrace(trace);
                        upload.setListener(new ArtifactUploadListener(catapult, upload));
                        artifactUploads.add(upload);
                    }
                    continue;
                }
                $ArtifactUpload $ArtifactUpload = new $ArtifactUpload(($Artifact)var17_21, var17_21.getFile());
                $ArtifactUpload.setTrace(trace);
                $ArtifactUpload.setListener(new ArtifactUploadListener(catapult, $ArtifactUpload));
                artifactUploads.add($ArtifactUpload);
            }
            connector.put(artifactUploads, null);
            for ($ArtifactUpload $ArtifactUpload : artifactUploads) {
                if ($ArtifactUpload.getException() != null) {
                    throw new $DeploymentException("Failed to deploy artifacts: " + $ArtifactUpload.getException().getMessage(), $ArtifactUpload.getException());
                }
                result.addArtifact($ArtifactUpload.getArtifact());
            }
            metadatas = $Utils.finishMetadata(generators, artifacts);
            syncContext.acquire(null, metadatas);
            for ($Metadata $Metadata : metadatas) {
                this.upload(metadataUploads, session, $Metadata, repository, connector, catapult);
                processedMetadata.put($Metadata, null);
            }
            for ($Metadata $Metadata : request.getMetadata()) {
                if (processedMetadata.containsKey($Metadata)) continue;
                this.upload(metadataUploads, session, $Metadata, repository, connector, catapult);
                processedMetadata.put($Metadata, null);
            }
            connector.put(null, metadataUploads);
            for ($MetadataUpload $MetadataUpload : metadataUploads) {
                if ($MetadataUpload.getException() != null) {
                    throw new $DeploymentException("Failed to deploy metadata: " + $MetadataUpload.getException().getMessage(), $MetadataUpload.getException());
                }
                result.addMetadata($MetadataUpload.getMetadata());
            }
        }
        finally {
            connector.close();
        }
        return result;
    }

    private List<? extends $MetadataGenerator> getMetadataGenerators($RepositorySystemSession session, $DeployRequest request) {
        $PrioritizedComponents<$MetadataGeneratorFactory> factories = $Utils.sortMetadataGeneratorFactories(session, this.metadataFactories);
        ArrayList<$MetadataGenerator> generators = new ArrayList<$MetadataGenerator>();
        for ($PrioritizedComponent<$MetadataGeneratorFactory> factory : factories.getEnabled()) {
            $MetadataGenerator generator = factory.getComponent().newInstance(session, request);
            if (generator == null) continue;
            generators.add(generator);
        }
        return generators;
    }

    private void upload(Collection<$MetadataUpload> metadataUploads, $RepositorySystemSession session, $Metadata metadata, $RemoteRepository repository, $RepositoryConnector connector, EventCatapult catapult) throws $DeploymentException {
        $LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        File basedir = lrm.getRepository().getBasedir();
        File dstFile = new File(basedir, lrm.getPathForRemoteMetadata(metadata, repository, ""));
        if (metadata instanceof $MergeableMetadata) {
            if (!(($MergeableMetadata)metadata).isMerged()) {
                $RepositoryEvent.Builder event = new $RepositoryEvent.Builder(session, $RepositoryEvent.EventType.METADATA_RESOLVING);
                event.setTrace(catapult.getTrace());
                event.setMetadata(metadata);
                event.setRepository(repository);
                this.repositoryEventDispatcher.dispatch(event.build());
                event = new $RepositoryEvent.Builder(session, $RepositoryEvent.EventType.METADATA_DOWNLOADING);
                event.setTrace(catapult.getTrace());
                event.setMetadata(metadata);
                event.setRepository(repository);
                this.repositoryEventDispatcher.dispatch(event.build());
                $RepositoryPolicy policy = this.getPolicy(session, repository, metadata.getNature());
                $MetadataDownload download = new $MetadataDownload();
                download.setMetadata(metadata);
                download.setFile(dstFile);
                download.setChecksumPolicy(policy.getChecksumPolicy());
                download.setListener($SafeTransferListener.wrap(session));
                download.setTrace(catapult.getTrace());
                connector.get(null, Collections.singletonList(download));
                $MetadataTransferException error = download.getException();
                if (error instanceof $MetadataNotFoundException) {
                    dstFile.delete();
                }
                event = new $RepositoryEvent.Builder(session, $RepositoryEvent.EventType.METADATA_DOWNLOADED);
                event.setTrace(catapult.getTrace());
                event.setMetadata(metadata);
                event.setRepository(repository);
                event.setException(error);
                event.setFile(dstFile);
                this.repositoryEventDispatcher.dispatch(event.build());
                event = new $RepositoryEvent.Builder(session, $RepositoryEvent.EventType.METADATA_RESOLVED);
                event.setTrace(catapult.getTrace());
                event.setMetadata(metadata);
                event.setRepository(repository);
                event.setException(error);
                event.setFile(dstFile);
                this.repositoryEventDispatcher.dispatch(event.build());
                if (error != null && !(error instanceof $MetadataNotFoundException)) {
                    throw new $DeploymentException("Failed to retrieve remote metadata " + metadata + ": " + error.getMessage(), error);
                }
            }
            try {
                (($MergeableMetadata)metadata).merge(dstFile, dstFile);
            }
            catch ($RepositoryException e) {
                throw new $DeploymentException("Failed to update metadata " + metadata + ": " + e.getMessage(), e);
            }
        }
        if (metadata.getFile() == null) {
            throw new $DeploymentException("Failed to update metadata " + metadata + ": No file attached.");
        }
        try {
            this.fileProcessor.copy(metadata.getFile(), dstFile);
        }
        catch (IOException e) {
            throw new $DeploymentException("Failed to update metadata " + metadata + ": " + e.getMessage(), e);
        }
        $UpdateCheck<$Metadata, $MetadataTransferException> check = new $UpdateCheck<$Metadata, $MetadataTransferException>();
        check.setItem(metadata);
        check.setFile(dstFile);
        check.setRepository(repository);
        check.setAuthoritativeRepository(repository);
        this.updateCheckManager.touchMetadata(session, check);
        $MetadataUpload upload = new $MetadataUpload(metadata, dstFile);
        upload.setTrace(catapult.getTrace());
        upload.setListener(new MetadataUploadListener(catapult, upload));
        metadataUploads.add(upload);
    }

    private $RepositoryPolicy getPolicy($RepositorySystemSession session, $RemoteRepository repository, $Metadata.Nature nature) {
        boolean releases = !$Metadata.Nature.SNAPSHOT.equals((Object)nature);
        boolean snapshots = !$Metadata.Nature.RELEASE.equals((Object)nature);
        return this.remoteRepositoryManager.getPolicy(session, repository, releases, snapshots);
    }

    static final class EventCatapult {
        private final $RepositorySystemSession session;
        private final $RequestTrace trace;
        private final $RemoteRepository repository;
        private final $RepositoryEventDispatcher dispatcher;

        EventCatapult($RepositorySystemSession session, $RequestTrace trace, $RemoteRepository repository, $RepositoryEventDispatcher dispatcher) {
            this.session = session;
            this.trace = trace;
            this.repository = repository;
            this.dispatcher = dispatcher;
        }

        public $RepositorySystemSession getSession() {
            return this.session;
        }

        public $RequestTrace getTrace() {
            return this.trace;
        }

        public void artifactDeploying($Artifact artifact, File file) {
            $RepositoryEvent.Builder event = new $RepositoryEvent.Builder(this.session, $RepositoryEvent.EventType.ARTIFACT_DEPLOYING);
            event.setTrace(this.trace);
            event.setArtifact(artifact);
            event.setRepository(this.repository);
            event.setFile(file);
            this.dispatcher.dispatch(event.build());
        }

        public void artifactDeployed($Artifact artifact, File file, $ArtifactTransferException exception) {
            $RepositoryEvent.Builder event = new $RepositoryEvent.Builder(this.session, $RepositoryEvent.EventType.ARTIFACT_DEPLOYED);
            event.setTrace(this.trace);
            event.setArtifact(artifact);
            event.setRepository(this.repository);
            event.setFile(file);
            event.setException(exception);
            this.dispatcher.dispatch(event.build());
        }

        public void metadataDeploying($Metadata metadata, File file) {
            $RepositoryEvent.Builder event = new $RepositoryEvent.Builder(this.session, $RepositoryEvent.EventType.METADATA_DEPLOYING);
            event.setTrace(this.trace);
            event.setMetadata(metadata);
            event.setRepository(this.repository);
            event.setFile(file);
            this.dispatcher.dispatch(event.build());
        }

        public void metadataDeployed($Metadata metadata, File file, Exception exception) {
            $RepositoryEvent.Builder event = new $RepositoryEvent.Builder(this.session, $RepositoryEvent.EventType.METADATA_DEPLOYED);
            event.setTrace(this.trace);
            event.setMetadata(metadata);
            event.setRepository(this.repository);
            event.setFile(file);
            event.setException(exception);
            this.dispatcher.dispatch(event.build());
        }
    }

    static final class ArtifactUploadListener
    extends $SafeTransferListener {
        private final EventCatapult catapult;
        private final $ArtifactUpload transfer;

        ArtifactUploadListener(EventCatapult catapult, $ArtifactUpload transfer) {
            super(catapult.getSession());
            this.catapult = catapult;
            this.transfer = transfer;
        }

        @Override
        public void transferInitiated($TransferEvent event) throws $TransferCancelledException {
            super.transferInitiated(event);
            Objects.requireNonNull(event, "event cannot be null");
            this.catapult.artifactDeploying(this.transfer.getArtifact(), this.transfer.getFile());
        }

        @Override
        public void transferFailed($TransferEvent event) {
            super.transferFailed(event);
            Objects.requireNonNull(event, "event cannot be null");
            this.catapult.artifactDeployed(this.transfer.getArtifact(), this.transfer.getFile(), this.transfer.getException());
        }

        @Override
        public void transferSucceeded($TransferEvent event) {
            super.transferSucceeded(event);
            Objects.requireNonNull(event, "event cannot be null");
            this.catapult.artifactDeployed(this.transfer.getArtifact(), this.transfer.getFile(), null);
        }
    }

    static final class MetadataUploadListener
    extends $SafeTransferListener {
        private final EventCatapult catapult;
        private final $MetadataUpload transfer;

        MetadataUploadListener(EventCatapult catapult, $MetadataUpload transfer) {
            super(catapult.getSession());
            this.catapult = catapult;
            this.transfer = transfer;
        }

        @Override
        public void transferInitiated($TransferEvent event) throws $TransferCancelledException {
            super.transferInitiated(event);
            Objects.requireNonNull(event, "event cannot be null");
            this.catapult.metadataDeploying(this.transfer.getMetadata(), this.transfer.getFile());
        }

        @Override
        public void transferFailed($TransferEvent event) {
            super.transferFailed(event);
            Objects.requireNonNull(event, "event cannot be null");
            this.catapult.metadataDeployed(this.transfer.getMetadata(), this.transfer.getFile(), this.transfer.getException());
        }

        @Override
        public void transferSucceeded($TransferEvent event) {
            super.transferSucceeded(event);
            Objects.requireNonNull(event, "event cannot be null");
            this.catapult.metadataDeployed(this.transfer.getMetadata(), this.transfer.getFile(), null);
        }
    }
}

