/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.maven.org.apache.http.protocol;

import de.softwareforge.testing.maven.org.apache.http.$HttpConnection;
import de.softwareforge.testing.maven.org.apache.http.$HttpException;
import de.softwareforge.testing.maven.org.apache.http.$HttpHost;
import de.softwareforge.testing.maven.org.apache.http.$HttpInetConnection;
import de.softwareforge.testing.maven.org.apache.http.$HttpRequest;
import de.softwareforge.testing.maven.org.apache.http.$HttpRequestInterceptor;
import de.softwareforge.testing.maven.org.apache.http.$HttpVersion;
import de.softwareforge.testing.maven.org.apache.http.$ProtocolException;
import de.softwareforge.testing.maven.org.apache.http.$ProtocolVersion;
import de.softwareforge.testing.maven.org.apache.http.annotation.;
import de.softwareforge.testing.maven.org.apache.http.protocol.$HttpContext;
import de.softwareforge.testing.maven.org.apache.http.protocol.$HttpCoreContext;
import de.softwareforge.testing.maven.org.apache.http.util.$Args;
import java.io.IOException;
import java.net.InetAddress;

@.Contract(threading=.ThreadingBehavior.IMMUTABLE)
public class $RequestTargetHost
implements $HttpRequestInterceptor {
    @Override
    public void process($HttpRequest request, $HttpContext context) throws $HttpException, IOException {
        $Args.notNull(request, "HTTP request");
        $HttpCoreContext coreContext = $HttpCoreContext.adapt(context);
        $ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals($HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            $HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                $HttpConnection conn = coreContext.getConnection();
                if (conn instanceof $HttpInetConnection) {
                    InetAddress address = (($HttpInetConnection)conn).getRemoteAddress();
                    int port = (($HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new $HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals($HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new $ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

