/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.treetable.j;

import de.sciss.treetable.j.TreeTable;
import de.sciss.treetable.j.TreeTableCellEditor;
import de.sciss.treetable.j.TreeTableCellRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.EventObject;
import javax.swing.CellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

public class CellEditorContainer<E extends CellEditor>
extends Container
implements TreeTableCellEditor,
TableCellEditor {
    protected E editor;
    protected transient TreeTableCellRenderer renderer;
    protected transient Component rendererComponent;
    protected transient Dimension rendererSize;
    protected transient Component editingComponent;
    protected transient int iconOffset;

    public CellEditorContainer(E editor) {
        this.editor = editor;
    }

    public void clearState() {
        this.removeAll();
        this.renderer = null;
        this.rendererSize = null;
        this.editingComponent = null;
    }

    @Override
    public Component getTreeTableCellEditorComponent(TreeTable treeTable, Object value, boolean selected, int row, int column) {
        return this.getEditorComponent(treeTable, value, selected, row, column, false, false, false);
    }

    @Override
    public Component getTreeTableCellEditorComponent(TreeTable treeTable, Object value, boolean selected, int row, int column, boolean expanded, boolean leaf) {
        return this.getEditorComponent(treeTable, value, selected, row, column, true, expanded, leaf);
    }

    private Component getEditorComponent(TreeTable treeTable, Object value, boolean sel, int row, int col, boolean treeColumn, boolean exp, boolean leaf) {
        if (this.editingComponent != null) {
            this.remove(this.editingComponent);
        }
        this.renderer = treeTable.getCellRenderer(row, col);
        this.rendererComponent = this.renderer.getTreeTableCellRendererComponent(treeTable, value, sel, true, row, col, exp, leaf);
        Component rc = this.rendererComponent;
        Dimension dimension = this.rendererSize = rc == null ? null : rc.getPreferredSize();
        if (treeColumn) {
            Icon editingIcon;
            JLabel label = rc instanceof JLabel ? (JLabel)rc : null;
            Icon icon = editingIcon = label == null ? null : label.getIcon();
            this.iconOffset = editingIcon != null ? label.getIconTextGap() + editingIcon.getIconWidth() : (label == null ? 4 : label.getIconTextGap());
            --this.iconOffset;
        } else {
            this.iconOffset = 0;
        }
        Component component = this.editingComponent = treeColumn ? this.getCellEditorComponent(treeTable, value, sel, row, col, exp, leaf) : this.getCellEditorComponent(treeTable, value, sel, row, col);
        if (this.editingComponent != null) {
            this.add(this.editingComponent);
        }
        return this;
    }

    protected Component getCellEditorComponent(TreeTable treeTable, Object value, boolean selected, int row, int column, boolean expanded, boolean leaf) {
        if (this.editor instanceof TreeTableCellEditor) {
            return ((TreeTableCellEditor)this.editor).getTreeTableCellEditorComponent(treeTable, value, selected, row, column, expanded, leaf);
        }
        return null;
    }

    protected Component getCellEditorComponent(TreeTable treeTable, Object value, boolean selected, int row, int column) {
        if (this.editor instanceof TreeTableCellEditor) {
            return ((TreeTableCellEditor)this.editor).getTreeTableCellEditorComponent(treeTable, value, selected, row, column);
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.editor.addCellEditorListener(l);
    }

    @Override
    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return this.editor.isCellEditable(e);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.editor.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.editor.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    @Override
    public void doLayout() {
        if (this.editingComponent != null) {
            int w;
            int x;
            if (this.getComponentOrientation().isLeftToRight()) {
                x = this.iconOffset;
                w = this.getWidth() - x;
            } else {
                x = 0;
                w = this.getWidth() - this.iconOffset;
            }
            this.editingComponent.setBounds(x, 0, w, this.getHeight());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.editingComponent != null) {
            Dimension pSize = this.editingComponent.getPreferredSize();
            pSize.width += this.iconOffset + 5;
            if (this.rendererSize != null) {
                pSize.height = Math.max(pSize.height, this.rendererSize.height);
            }
            return pSize;
        }
        return new Dimension(0, 0);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
        throw new UnsupportedOperationException();
    }
}

