/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.query;

import java.io.Serializable;
import org.nustaq.reallive.query.DoubleValue;
import org.nustaq.reallive.query.LongValue;
import org.nustaq.reallive.query.StringValue;

public interface Value
extends Serializable {
    public static final Value TRUE = new LongValue(1L);
    public static final Value FALSE = new LongValue(0L);

    public double getDoubleValue();

    public long getLongValue();

    public String getStringValue();

    default public boolean isDouble() {
        return this instanceof DoubleValue;
    }

    default public boolean isLong() {
        return this instanceof LongValue;
    }

    default public boolean isString() {
        return this instanceof StringValue;
    }

    default public boolean isTrue() {
        if (this.isString()) {
            String sv = this.getStringValue();
            return !"false".equals(sv) && sv.length() > 0 && !"0".equals(sv);
        }
        return this.getLongValue() != 0L;
    }

    public Value negate();
}

