/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl.tablespace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.nustaq.kontraktor.Actors;
import org.nustaq.kontraktor.Callback;
import org.nustaq.kontraktor.IPromise;
import org.nustaq.kontraktor.Promise;
import org.nustaq.kontraktor.util.Log;
import org.nustaq.reallive.impl.actors.ShardFunc;
import org.nustaq.reallive.impl.actors.TableSharding;
import org.nustaq.reallive.impl.storage.StorageStats;
import org.nustaq.reallive.impl.tablespace.TableSpaceActor;
import org.nustaq.reallive.interfaces.RealLiveTable;
import org.nustaq.reallive.interfaces.TableDescription;
import org.nustaq.reallive.interfaces.TableSpace;
import org.nustaq.reallive.messages.StateMessage;

public class TableSpaceSharding
implements TableSpace {
    TableSpaceActor[] shards;
    HashMap<String, RealLiveTable> tableMap = new HashMap();
    HashMap<String, TableDescription> tableDescriptionMap = new HashMap();
    ShardFunc func;

    public TableSpaceSharding(TableSpaceActor[] shards, ShardFunc func) {
        this.shards = shards;
        this.func = func;
    }

    public IPromise init() {
        return new Promise((Object)"done");
    }

    @Override
    public IPromise<RealLiveTable> createOrLoadTable(TableDescription desc) {
        Promise res = new Promise();
        ArrayList<Promise> results = new ArrayList<Promise>();
        int i = 0;
        while (i < this.shards.length) {
            TableSpaceActor shard = this.shards[i];
            IPromise<RealLiveTable> table = shard.createOrLoadTable(desc.clone().shardNo(i));
            Promise p = new Promise();
            results.add(p);
            int finalI = i++;
            table.then((Callback & Serializable)(r, e) -> {
                if (e == null) {
                    Log.Info((Object)this, (String)("table creation: " + finalI));
                } else {
                    Log.Info((Object)this, (String)("failed table creation: " + finalI + " " + e));
                }
                p.complete(r, e);
            });
        }
        List tables = (List)Actors.all(results).await();
        RealLiveTable[] tableShards = new RealLiveTable[tables.size()];
        boolean errors = false;
        for (int i2 = 0; i2 < tables.size(); ++i2) {
            if (((IPromise)tables.get(i2)).get() == null) {
                res.reject(((IPromise)tables.get(i2)).getError());
                errors = true;
                break;
            }
            int sno = i2;
            if (tableShards[sno] != null) {
                res.reject((Object)("shard " + sno + " is present more than once"));
                errors = true;
                break;
            }
            tableShards[sno] = (RealLiveTable)((IPromise)tables.get(i2)).get();
        }
        if (!errors) {
            TableSharding ts = new TableSharding(this.func, tableShards, desc);
            this.tableMap.put(desc.getName(), ts);
            this.tableDescriptionMap.put(desc.getName(), desc);
            res.resolve(ts);
        }
        return res;
    }

    @Override
    public IPromise dropTable(String name) {
        ArrayList<IPromise> results = new ArrayList<IPromise>();
        for (int i = 0; i < this.shards.length; ++i) {
            TableSpaceActor shard = this.shards[i];
            results.add(shard.dropTable(name));
        }
        return Actors.all(results);
    }

    @Override
    public IPromise<List<TableDescription>> getTableDescriptions() {
        List collect = this.tableMap.values().stream().map(ts -> ts.getDescription()).collect(Collectors.toList());
        return Actors.allMapped(collect);
    }

    public List<StorageStats> getStats() {
        return this.tableMap.keySet().stream().map(tableName -> ((StorageStats)this.tableMap.get(tableName).getStats().await()).tableName((String)tableName)).collect(Collectors.toList());
    }

    @Override
    public IPromise<List<RealLiveTable>> getTables() {
        return new Promise(new ArrayList<RealLiveTable>(this.tableMap.values()));
    }

    @Override
    public IPromise<RealLiveTable> getTable(String name) {
        return Actors.resolve((Object)this.tableMap.get(name));
    }

    @Override
    public IPromise shutDown() {
        return new Promise((Object)"void");
    }

    @Override
    public void stateListener(Callback<StateMessage> stateListener) {
        throw new RuntimeException("unimplemented");
    }
}

