/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.impl.storage;

import java.util.HashMap;
import java.util.Map;
import org.nustaq.kontraktor.Spore;
import org.nustaq.reallive.impl.storage.StorageStats;
import org.nustaq.reallive.interfaces.Record;
import org.nustaq.reallive.interfaces.RecordStorage;

public class HeapRecordStorage<K>
implements RecordStorage<K> {
    Map<K, Record<K>> map = new HashMap<K, Record<K>>();

    @Override
    public RecordStorage put(K key, Record<K> value) {
        this.map.put(key, value);
        return this;
    }

    @Override
    public Record<K> get(K key) {
        return this.map.get(key);
    }

    @Override
    public Record<K> remove(K key) {
        return this.map.remove(key);
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public <T> void forEach(Spore<Record<K>, T> spore) {
        long now = System.currentTimeMillis();
        for (Record<K> record : this.map.values()) {
            spore.remote(record);
            if (!spore.isFinished()) continue;
            break;
        }
        spore.finish();
        System.out.println("dur:" + (System.currentTimeMillis() - now) + " " + this.map.size());
    }

    public Map<K, Record<K>> getMap() {
        return this.map;
    }

    @Override
    public StorageStats getStats() {
        StorageStats stats = new StorageStats().capacity(-1L).freeMem(-1L).usedMem(-1L).numElems(this.map.size());
        return stats;
    }
}

