/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.reallive.client;

import org.nustaq.reallive.impl.StorageDriver;
import org.nustaq.reallive.impl.storage.HeapRecordStorage;
import org.nustaq.reallive.interfaces.RLPredicate;
import org.nustaq.reallive.interfaces.RealLiveTable;
import org.nustaq.reallive.interfaces.Record;
import org.nustaq.reallive.interfaces.Subscriber;

public class SubscribedSet<K> {
    final RealLiveTable<K> source;
    StorageDriver<K> storage;
    Subscriber<K> subs;

    public SubscribedSet(RealLiveTable<K> source) {
        this.source = source;
        this.storage = new StorageDriver(new HeapRecordStorage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(RLPredicate<Record<K>> filter) {
        SubscribedSet subscribedSet = this;
        synchronized (subscribedSet) {
            this.unsubscribe();
            this.subs = new Subscriber<K>(filter, change -> {
                SubscribedSet subscribedSet = this;
                synchronized (subscribedSet) {
                    this.storage.receive(change);
                }
            });
            this.source.subscribe(this.subs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe() {
        SubscribedSet subscribedSet = this;
        synchronized (subscribedSet) {
            if (this.subs != null) {
                this.source.unsubscribe(this.subs);
                this.subs = null;
            }
        }
    }

    public Record<K> getAnyRecord() {
        return null;
    }
}

