/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.heapoff.structs;

import de.ruedigermoeller.heapoff.bytez.Bytez;
import de.ruedigermoeller.heapoff.structs.FSTStruct;
import java.io.Serializable;

public class FSTStructChange
implements Serializable {
    int[] changeOffsets;
    int[] changeLength = new int[4];
    int curIndex;
    byte[] snapshot;

    public FSTStructChange() {
        this.changeOffsets = new int[4];
    }

    public void addChange(int offset, int len) {
        this.addChange((long)offset, (long)len);
    }

    public void addChange(long offset, int len) {
        this.addChange(offset, (long)len);
    }

    public void addChange(long offset, long len) {
        if (this.curIndex > 0 && (long)(this.changeOffsets[this.curIndex - 1] + this.changeLength[this.curIndex - 1]) == offset) {
            int n = this.curIndex - 1;
            this.changeLength[n] = (int)((long)this.changeLength[n] + len);
            return;
        }
        if (this.curIndex >= this.changeOffsets.length) {
            int[] newOff = new int[this.changeOffsets.length * 2];
            System.arraycopy(this.changeOffsets, 0, newOff, 0, this.changeOffsets.length);
            int[] newLen = new int[this.changeOffsets.length * 2];
            System.arraycopy(this.changeLength, 0, newLen, 0, this.changeLength.length);
            this.changeOffsets = newOff;
            this.changeLength = newLen;
        }
        this.changeOffsets[this.curIndex] = (int)offset;
        this.changeLength[this.curIndex] = (int)len;
        ++this.curIndex;
    }

    public void rebase(int toSubtract) {
        int i = 0;
        while (i < this.curIndex) {
            int n = i++;
            this.changeOffsets[n] = this.changeOffsets[n] - toSubtract;
        }
    }

    public void snapshotChanges(int originBase, Bytez origin) {
        int sumLen = 0;
        for (int i = 0; i < this.curIndex; ++i) {
            sumLen += this.changeLength[i];
        }
        this.snapshot = new byte[sumLen];
        int targetIdx = 0;
        for (int i = 0; i < this.curIndex; ++i) {
            int changeOffset = this.changeOffsets[i];
            int len = this.changeLength[i];
            for (int ii = 0; ii < len; ++ii) {
                this.snapshot[targetIdx++] = origin.get(changeOffset + ii);
            }
        }
        this.rebase(originBase);
    }

    public void applySnapshot(FSTStruct target) {
        Bytez arr = target.getBase();
        int baseIdx = (int)target.getOffset();
        int snapIdx = 0;
        for (int i = 0; i < this.curIndex; ++i) {
            int changeOffset = this.changeOffsets[i];
            int len = this.changeLength[i];
            for (int ii = 0; ii < len; ++ii) {
                arr.put(baseIdx + changeOffset + ii, this.snapshot[snapIdx++]);
            }
        }
    }

    public void test_applyChangesTo(int originBase, byte[] origin, FSTStruct copy) {
        Bytez arr = copy.getBase();
        int baseIdx = (int)copy.getOffset();
        for (int i = 0; i < this.curIndex; ++i) {
            int changeOffset = this.changeOffsets[i];
            int len = this.changeLength[i];
            for (int ii = 0; ii < len; ++ii) {
                arr.put(baseIdx + changeOffset - originBase + ii, origin[changeOffset + ii]);
            }
        }
    }

    public byte[] getSnapshot() {
        return this.snapshot;
    }
}

