/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.transport;

import de.ruedigermoeller.fastcast.util.FCLog;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.representer.Representer;

public class FCSocketConf {
    public static String MCAST_NIO_SOCKET = "MCAST_NIO_SOCKET";
    public static String MCAST_SOCKET = "MCAST_SOCKET";
    public static String MCAST_IPC = "MCAST_IPC";
    String name;
    int dgramsize = 8000;
    private String ifacAdr = "eth0";
    String mcastAdr = "229.9.9.9";
    int port = 45555;
    int trafficClass = 8;
    boolean loopBack = true;
    int ttl = 2;
    int receiveBufferSize = 30000000;
    int sendBufferSize = 640000;
    String transportType = MCAST_NIO_SOCKET;
    String queueFile;

    public FCSocketConf() {
    }

    public FCSocketConf(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getDgramsize() {
        return this.dgramsize;
    }

    public void setDgramsize(int dgramsize) {
        this.dgramsize = dgramsize;
    }

    public String getIfacAdr() {
        if (!Character.isDigit(this.ifacAdr.charAt(0))) {
            Enumeration<NetworkInterface> nets = null;
            try {
                nets = NetworkInterface.getNetworkInterfaces();
                for (NetworkInterface netint : Collections.list(nets)) {
                    if (!netint.getDisplayName().equalsIgnoreCase(this.ifacAdr)) continue;
                    Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                    if (inetAddresses.hasMoreElements()) {
                        this.ifacAdr = inetAddresses.nextElement().getHostAddress();
                        break;
                    }
                    FCLog.get().warn("specified interface " + this.ifacAdr + " does not have an IP assigned");
                }
            }
            catch (SocketException e) {
                FCLog.log(e);
            }
        }
        return this.ifacAdr;
    }

    public String getTransportType() {
        return this.transportType;
    }

    public void setTransportType(String transportType) {
        this.transportType = transportType;
    }

    public void setIfacAdr(String ifacAdr) {
        this.ifacAdr = ifacAdr;
    }

    public String getMcastAdr() {
        return this.mcastAdr;
    }

    public void setMcastAdr(String mcastAdr) {
        this.mcastAdr = mcastAdr;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public boolean isLoopBack() {
        return this.loopBack;
    }

    public void setLoopBack(boolean loopBack) {
        this.loopBack = loopBack;
    }

    public int getTtl() {
        return this.ttl;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public static void write(String finam, FCSocketConf data) throws IOException {
        DumperOptions opt = new DumperOptions();
        opt.setPrettyFlow(true);
        Representer representer = new Representer();
        Yaml yaml = new Yaml(representer, opt);
        FileWriter wri = new FileWriter(finam);
        wri.write(yaml.dumpAsMap((Object)data));
        wri.close();
    }

    public static FCSocketConf read(InputStream in) throws IOException {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(){

            protected Class<?> getClassForNode(Node node) {
                String name = node.getTag().getValue();
                if ("!topic".equals(name)) {
                    return FCSocketConf.class;
                }
                if ("!socket".equals(name)) {
                    return FCSocketConf.class;
                }
                return super.getClassForNode(node);
            }
        });
        FCSocketConf conf = (FCSocketConf)yaml.loadAs(in, FCSocketConf.class);
        in.close();
        return conf;
    }

    public static FCSocketConf read(String finam) throws IOException {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(){

            protected Class<?> getClassForNode(Node node) {
                String name = node.getTag().getValue();
                if ("!topic".equals(name)) {
                    return FCSocketConf.class;
                }
                if ("!socket".equals(name)) {
                    return FCSocketConf.class;
                }
                return super.getClassForNode(node);
            }
        });
        FileReader reader = new FileReader(finam);
        FCSocketConf conf = (FCSocketConf)yaml.loadAs((Reader)reader, FCSocketConf.class);
        reader.close();
        return conf;
    }

    public static void main(String[] arg) throws IOException {
        FCSocketConf conf = new FCSocketConf();
        FCSocketConf.write("/tmp/fcconf.yaml", conf);
        FCSocketConf read = FCSocketConf.read("/tmp/fcconf.yaml");
        System.out.println("pok " + read);
    }

    public String getQueueFile() {
        return this.queueFile;
    }

    public void setQueueFile(String queueFile) {
        this.queueFile = queueFile;
    }
}

