/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.transport;

import de.ruedigermoeller.fastcast.transport.FCSocketConf;
import de.ruedigermoeller.fastcast.transport.Transport;
import de.ruedigermoeller.fastcast.util.FCLog;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.MembershipKey;

public class FCMulticastChannelTransport
implements Transport {
    DatagramChannel receiveSocket;
    DatagramChannel sendSocket;
    FCSocketConf conf;
    NetworkInterface iface;
    InetAddress address;
    InetSocketAddress socketAddress;

    public FCMulticastChannelTransport(FCSocketConf conf) {
        System.setProperty("java.net.preferIPv4Stack", "true");
        this.conf = conf;
    }

    @Override
    public boolean receive(DatagramPacket pack) throws IOException {
        SocketAddress receive = this.receiveSocket.receive(ByteBuffer.wrap(pack.getData(), pack.getOffset(), pack.getLength()));
        if (receive instanceof InetSocketAddress) {
            pack.setAddress(((InetSocketAddress)receive).getAddress());
        }
        return receive != null;
    }

    @Override
    public void send(DatagramPacket pack) throws IOException {
        this.sendSocket.send(ByteBuffer.wrap(pack.getData(), pack.getOffset(), pack.getLength()), this.socketAddress);
    }

    public InetSocketAddress getAddress() {
        return this.socketAddress;
    }

    public NetworkInterface getInterface() {
        return this.iface;
    }

    @Override
    public void join() throws IOException {
        if (this.address == null) {
            this.address = InetAddress.getByName(this.conf.mcastAdr);
        }
        this.socketAddress = new InetSocketAddress(this.address, this.conf.port);
        if (this.iface == null && this.conf.getIfacAdr() != null) {
            this.iface = NetworkInterface.getByInetAddress(Inet4Address.getByName(this.conf.getIfacAdr()));
            if (this.iface == null) {
                this.iface = NetworkInterface.getByInetAddress(Inet4Address.getByName(this.conf.getIfacAdr()));
            }
            if (this.iface == null) {
                FCLog.log("Could not find a network interface named '" + this.conf.getIfacAdr() + "'");
            }
        }
        this.receiveSocket = this.ceateSocket();
        this.sendSocket = this.ceateSocket();
        MembershipKey key = this.receiveSocket.join(this.address, this.iface);
        FCLog.log("Connecting to interface " + this.iface.getName() + " on address " + this.address + " " + this.conf.port + " dgramsize:" + this.getConf().getDgramsize());
    }

    private DatagramChannel ceateSocket() throws IOException {
        DatagramChannel channel = ((DatagramChannel)((DatagramChannel)((DatagramChannel)((DatagramChannel)((DatagramChannel)((DatagramChannel)DatagramChannel.open(StandardProtocolFamily.INET).setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, this.iface)).setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.conf.receiveBufferSize)).setOption((SocketOption)StandardSocketOptions.IP_TOS, (Object)this.conf.trafficClass)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_LOOP, (Object)this.conf.loopBack)).setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.conf.ttl)).bind(new InetSocketAddress(this.conf.port));
        channel.configureBlocking(true);
        return channel;
    }

    @Override
    public FCSocketConf getConf() {
        return this.conf;
    }
}

