/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.service;

import de.ruedigermoeller.fastcast.packeting.TopicStats;
import de.ruedigermoeller.fastcast.remoting.FCFutureResultHandler;
import de.ruedigermoeller.fastcast.remoting.FCReceiveContext;
import de.ruedigermoeller.fastcast.remoting.FCTopicService;
import de.ruedigermoeller.fastcast.remoting.FastCast;
import de.ruedigermoeller.fastcast.remoting.Loopback;
import de.ruedigermoeller.fastcast.remoting.RemoteMethod;
import de.ruedigermoeller.fastcast.remoting.Unreliable;
import de.ruedigermoeller.fastcast.util.FCLog;
import de.ruedigermoeller.serialization.FSTObjectInput;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

@Unreliable
public class FCMembership
extends FCTopicService {
    protected boolean doLogClusterMessages = false;
    ConcurrentHashMap<String, NodePingInfo> lastPing = new ConcurrentHashMap();
    List<NodePingInfo> activeNodes = new ArrayList<NodePingInfo>();
    int heartbeatInterval = 1000;
    int timeoutAfterNIntervals = 5;
    FCMembership remote;
    MemberShipListener listener;
    volatile Object nodeState;

    public FCMembership() {
    }

    public FCMembership(int heartbeatInterval, int timeoutAfterNIntervals) {
        this.heartbeatInterval = heartbeatInterval;
        this.timeoutAfterNIntervals = timeoutAfterNIntervals;
    }

    public Object getNodeState() {
        return this.nodeState;
    }

    public void setNodeState(Object nodeState) {
        this.nodeState = nodeState;
    }

    public int getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public MemberShipListener getListener() {
        return this.listener;
    }

    public void setListener(MemberShipListener listener) {
        this.listener = listener;
    }

    public void setHeartbeatInterval(int heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public int getTimeoutAfterNIntervals() {
        return this.timeoutAfterNIntervals;
    }

    public void setTimeoutAfterNIntervals(int timeoutAfterNIntervals) {
        this.timeoutAfterNIntervals = timeoutAfterNIntervals;
    }

    @Override
    public void init() {
        this.remote = (FCMembership)((Object)this.getRemoting().getRemoteService(this.getTopicName()));
        new Thread("Pinger"){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(FCMembership.this.heartbeatInterval);
                    }
                    catch (InterruptedException e) {
                        FCLog.log(e);
                    }
                    FCMembership.this.remote.ping(System.currentTimeMillis(), FCMembership.this.nodeState);
                    FCMembership.this.activeNodes = FCMembership.this.updateActiveNodes(FCMembership.this.heartbeatInterval * FCMembership.this.timeoutAfterNIntervals);
                }
            }
        }.start();
    }

    @RemoteMethod(value=2)
    public synchronized void getStats(String topic, FCFutureResultHandler result) {
        TopicStats stats = this.getRemoting().getStats(topic);
        if (stats != null) {
            if (stats.getSnapshot() == null) {
                stats.reset();
            } else if (System.currentTimeMillis() - stats.getSnapshot().getRecordEnd() > 1000L) {
                stats.reset();
            }
            result.sendResult(stats.getSnapshot());
            return;
        }
        result.sendResult(null);
    }

    @RemoteMethod(value=3)
    public synchronized void getActiveTopics(FCFutureResultHandler res) {
        List<String> activeTopics = FastCast.getRemoting().getActiveTopics();
        for (int i = 0; i < activeTopics.size(); ++i) {
            String s = activeTopics.get(i);
            res.sendResult(s);
        }
    }

    @RemoteMethod(value=1)
    @Loopback
    public synchronized void ping(long timeSent, Object nodeStateObject) {
        String sender = FCReceiveContext.get().getSender();
        if (this.lastPing.get(sender) == null) {
            this.nodeAdded(sender, nodeStateObject);
        }
        this.lastPing.put(sender, new NodePingInfo(sender, System.currentTimeMillis(), nodeStateObject));
    }

    @RemoteMethod(value=4)
    public synchronized void getNodeInfo(FCFutureResultHandler res) {
        res.sendResult(new MemberNodeInfo(this.getNodeId()));
    }

    @RemoteMethod(value=5)
    public void clusterLog(String text) {
        FCLog.get().internal_clusterListenerLog(FCReceiveContext.get().getSender() + ":" + text);
    }

    @Override
    protected boolean invoke(int methodIndex, Method m, FSTObjectInput in, Class[] types) {
        if (methodIndex == 5) {
            return !this.doLogClusterMessages;
        }
        return false;
    }

    protected List<NodePingInfo> updateActiveNodes(long lastPingDelay) {
        ArrayList<NodePingInfo> res = new ArrayList<NodePingInfo>();
        Iterator iterator = this.lastPing.keySet().iterator();
        while (iterator.hasNext()) {
            String next = (String)iterator.next();
            if (System.currentTimeMillis() - this.lastPing.get(next).getTime() < lastPingDelay) {
                res.add(this.lastPing.get(next));
                continue;
            }
            iterator.remove();
            this.nodeLost(next);
        }
        return res;
    }

    public List<NodePingInfo> getActiveNodes() {
        return this.activeNodes;
    }

    public List<NodePingInfo> getActiveNodes(String subString) {
        ArrayList<NodePingInfo> res = new ArrayList<NodePingInfo>();
        List<NodePingInfo> copy = this.activeNodes;
        for (int i = 0; i < copy.size(); ++i) {
            String adr = copy.get(i).getSender();
            if (subString != null && adr.indexOf(subString) < 0) continue;
            res.add(copy.get(i));
        }
        return res;
    }

    public NodePingInfo[] getActiveNodesOrderDeterministic(String subString) {
        List<NodePingInfo> activeNodes = this.getActiveNodes(subString);
        NodePingInfo[] hostNodeAddresses = new NodePingInfo[activeNodes.size()];
        Collections.sort(activeNodes, new Comparator<NodePingInfo>(){

            @Override
            public int compare(NodePingInfo o1, NodePingInfo o2) {
                return o1.getSender().compareTo(o2.getSender());
            }
        });
        for (int i = 0; i < activeNodes.size(); ++i) {
            hostNodeAddresses[i] = activeNodes.get(i);
        }
        return hostNodeAddresses;
    }

    public <E> ArrayList<E> getActiveNodes(Class<E> nodeInfoClass) {
        List<NodePingInfo> activeNodes = this.getActiveNodes();
        ArrayList<Object> res = new ArrayList<Object>();
        for (int i = 0; i < activeNodes.size(); ++i) {
            NodePingInfo nodePingInfo = activeNodes.get(i);
            if (nodePingInfo.getNodeState() == null || !nodeInfoClass.isAssignableFrom(nodePingInfo.getNodeState().getClass())) continue;
            res.add(nodePingInfo.getNodeState());
        }
        return res;
    }

    public String[] getActiveNodeAdressesOrderDeterministic(String subString) {
        List<NodePingInfo> activeNodes = this.getActiveNodes(subString);
        String[] hostNodeAddresses = new String[activeNodes.size()];
        Collections.sort(activeNodes, new Comparator<NodePingInfo>(){

            @Override
            public int compare(NodePingInfo o1, NodePingInfo o2) {
                return o1.getSender().compareTo(o2.getSender());
            }
        });
        for (int i = 0; i < activeNodes.size(); ++i) {
            hostNodeAddresses[i] = activeNodes.get(i).getSender();
        }
        return hostNodeAddresses;
    }

    public String dumpToString() {
        List<NodePingInfo> nodes = this.activeNodes;
        StringBuffer res = new StringBuffer();
        res.append("----------------------------------------\n");
        for (int i = 0; i < nodes.size(); ++i) {
            NodePingInfo o = nodes.get(i);
            res.append("Node: " + o + "\n");
        }
        res.append("----------------------------------------\n");
        return res.toString();
    }

    public void dump() {
        FCLog.log(this.dumpToString());
    }

    public void nodeAdded(String sender, Object nodeState) {
        if (this.listener != null) {
            this.listener.nodeAdded(sender, nodeState);
        }
    }

    public void nodeLost(String lostNode) {
        if (this.listener != null) {
            this.listener.nodeLost(lostNode);
        }
    }

    public boolean isDoLogClusterMessages() {
        return this.doLogClusterMessages;
    }

    public void setDoLogClusterMessages(boolean doLogClusterMessages) {
        this.doLogClusterMessages = doLogClusterMessages;
    }

    public static class MemberNodeInfo
    implements Serializable {
        private final int procs;
        String nodeId;
        long maxMemMB;
        String hostName;

        public MemberNodeInfo(String node) {
            this.nodeId = node;
            this.maxMemMB = Runtime.getRuntime().maxMemory() / 1000L / 1000L;
            this.procs = Runtime.getRuntime().availableProcessors();
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this.hostName = "unknown";
            }
        }

        public int getProcs() {
            return this.procs;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public long getMaxMemMB() {
            return this.maxMemMB;
        }

        public void setMaxMemMB(long maxMemMB) {
            this.maxMemMB = maxMemMB;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public String toString() {
            return "" + this.nodeId + " [" + this.hostName + ", " + this.maxMemMB + " MB, " + this.procs + " cores]";
        }
    }

    public static class NodePingInfo {
        long time;
        Object nodeState;
        String sender;

        public NodePingInfo(String sender, long time, Object nodeState) {
            this.time = time;
            this.nodeState = nodeState;
            this.sender = sender;
        }

        public long getTime() {
            return this.time;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public Object getNodeState() {
            return this.nodeState;
        }

        public void setNodeState(Object nodeState) {
            this.nodeState = nodeState;
        }

        public String getSender() {
            return this.sender;
        }

        public String toString() {
            return "NodePingInfo{time=" + this.time + ", nodeState=" + this.nodeState + ", sender='" + this.sender + '\'' + '}';
        }
    }

    public static interface MemberShipListener {
        public void nodeAdded(String var1, Object var2);

        public void nodeLost(String var1);
    }
}

