/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.remoting;

import de.ruedigermoeller.fastcast.packeting.PacketSendBuffer;
import de.ruedigermoeller.fastcast.packeting.TopicEntry;
import de.ruedigermoeller.fastcast.remoting.FCFutureResultHandler;
import de.ruedigermoeller.fastcast.remoting.FCInvoker;
import de.ruedigermoeller.fastcast.remoting.FCRemoteServiceProxy;
import de.ruedigermoeller.fastcast.remoting.FastCast;
import de.ruedigermoeller.fastcast.remoting.Loopback;
import de.ruedigermoeller.fastcast.remoting.RemoteHelper;
import de.ruedigermoeller.fastcast.remoting.RemoteMethod;
import de.ruedigermoeller.fastcast.remoting.Unordered;
import de.ruedigermoeller.fastcast.remoting.Unreliable;
import de.ruedigermoeller.fastcast.util.FCLog;
import de.ruedigermoeller.serialization.FSTObjectInput;
import java.io.Externalizable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtPrimitiveType;
import javassist.Loader;
import javassist.Modifier;
import javassist.NotFoundException;

public class FCProxyFactory {
    static HashMap<String, Class> generatedProxyClasses = new HashMap();
    static HashMap<String, FCInvoker> generatedCallerClasses = new HashMap();

    public FCInvoker getMethod(String serviceClass, int index) {
        return generatedCallerClasses.get(serviceClass + "#" + index);
    }

    protected <T> T createProxy(Class<T> serviceClz, TopicEntry topic, FastCast fastCast) throws Exception {
        Object instance;
        block3: {
            Class<T> proxyClass = this.createProxyClass(serviceClz, topic.getConf().getName());
            Constructor<?>[] constructors = proxyClass.getConstructors();
            instance = null;
            try {
                instance = proxyClass.newInstance();
            }
            catch (Exception e) {
                for (int i = 0; i < constructors.length; ++i) {
                    Constructor<?> constructor = constructors[i];
                    if (constructor.getParameterTypes().length != 1) continue;
                    instance = constructor.newInstance(new Object[]{null});
                    break;
                }
                if (instance != null) break block3;
                throw e;
            }
        }
        Field f = instance.getClass().getField("marshaller");
        f.setAccessible(true);
        f.set(instance, fastCast);
        f = instance.getClass().getField("topic");
        f.setAccessible(true);
        f.set(instance, topic);
        f = instance.getClass().getField("sender");
        f.setAccessible(true);
        f.set(instance, topic.getSender());
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Class<T> createProxyClass(Class<T> clazz, String topic) throws NotFoundException, CannotCompileException, IllegalAccessException, InstantiationException, NoSuchFieldException, ClassNotFoundException {
        HashMap<String, Class> hashMap = generatedProxyClasses;
        synchronized (hashMap) {
            String proxyName = clazz.getName() + "Proxy";
            String key = clazz.getName() + "#" + topic;
            Class ccClz = generatedProxyClasses.get(key);
            if (ccClz == null) {
                ClassPool pool = ClassPool.getDefault();
                CtClass cc = null;
                try {
                    cc = pool.getCtClass(proxyName);
                }
                catch (NotFoundException ex) {
                    // empty catch block
                }
                if (cc == null) {
                    cc = pool.makeClass(proxyName);
                    CtClass orig = pool.get(clazz.getName());
                    if (clazz.isInterface()) {
                        cc.setInterfaces(new CtClass[]{orig, pool.get(Externalizable.class.getName()), pool.get(FCRemoteServiceProxy.class.getName())});
                    } else {
                        cc.setSuperclass(orig);
                        cc.setInterfaces(new CtClass[]{pool.get(Externalizable.class.getName()), pool.get(FCRemoteServiceProxy.class.getName())});
                    }
                    this.defineProxyFields(pool, cc);
                    boolean hasResultMethods = this.defineProxyMethods(cc, orig, topic, clazz.isInterface());
                    this.defineFCRemoteObjectMethods(pool, cc, clazz.getName(), hasResultMethods);
                }
                ccClz = this.loadProxyClass(clazz, pool, cc);
                generatedProxyClasses.put(key, ccClz);
            }
            return ccClz;
        }
    }

    protected <T> Class loadProxyClass(Class clazz, ClassPool pool, final CtClass cc) throws ClassNotFoundException {
        Loader cl = new Loader(clazz.getClassLoader(), pool){

            protected Class loadClassByDelegation(String name) throws ClassNotFoundException {
                if (name.equals(cc.getName())) {
                    return null;
                }
                return this.delegateToParent(name);
            }
        };
        Class ccClz = cl.loadClass(cc.getName());
        return ccClz;
    }

    protected void defineProxyFields(ClassPool pool, CtClass cc) throws CannotCompileException, NotFoundException {
        CtField marsh = new CtField(pool.get(FastCast.class.getName()), "marshaller", cc);
        marsh.setModifiers(1);
        cc.addField(marsh);
        CtField topic = new CtField(pool.get(TopicEntry.class.getName()), "topic", cc);
        topic.setModifiers(1);
        cc.addField(topic);
        CtField sender = new CtField(pool.get(PacketSendBuffer.class.getName()), "sender", cc);
        sender.setModifiers(1);
        cc.addField(sender);
    }

    protected boolean defineProxyMethods(CtClass cc, CtClass orig, String topic, boolean isInterf) throws CannotCompileException, NotFoundException, ClassNotFoundException {
        CtMethod[] methods = this.getSortedPublicCtMethods(orig, false);
        boolean hasResultCalls = false;
        for (int i = 0; i < methods.length; ++i) {
            boolean allowed;
            CtMethod method;
            CtMethod originalMethod = method = methods[i];
            method = new CtMethod(method, cc, null);
            CtClass[] parameterTypes = method.getParameterTypes();
            CtClass returnType = method.getReturnType();
            Object remote = originalMethod.getAnnotation(RemoteMethod.class);
            Object loopback = originalMethod.getAnnotation(Loopback.class);
            Object unreliable = originalMethod.getAnnotation(Unreliable.class);
            Object unordered = originalMethod.getAnnotation(Unordered.class);
            boolean bl = allowed = ((method.getModifiers() & 0x400) == 0 || isInterf) && (method.getModifiers() & 0x100) == 0 && (method.getModifiers() & 0x10) == 0;
            if (allowed) {
                if ((method.getModifiers() & 1) == 1 && returnType == CtPrimitiveType.voidType && remote != null) {
                    String remotecall;
                    byte methodIndex = ((RemoteMethod)originalMethod.getAnnotation(RemoteMethod.class)).value();
                    if (this.isRemoteResultCall(method)) {
                        hasResultCalls = true;
                    }
                    if (methodIndex == -1) {
                        remotecall = "{ if (sender==null) sender=topic.getSender(); marshaller.sendBinaryContent( topic, sender, $1, $2, $3, " + (loopback != null) + " ); }";
                        method.setBody(remotecall);
                    } else if (loopback == null && this.isFastCall(method)) {
                        String body = "{ if (sender==null) sender=topic.getSender(); de.ruedigermoeller.serialization.FSTObjectOutput out = marshaller.prepareFastCall(" + methodIndex + ", " + parameterTypes.length + ");";
                        for (int j = 0; j < parameterTypes.length; ++j) {
                            CtClass parameterType = parameterTypes[j];
                            if (parameterType.isArray()) {
                                parameterType = parameterType.getComponentType();
                                body = body + " out.writeFInt( $" + (j + 1) + ".length );";
                                if (parameterType == CtClass.booleanType) {
                                    body = body + " out.writeFBooleanArr( $" + (j + 1) + ");";
                                    continue;
                                }
                                if (parameterType == CtClass.byteType) {
                                    body = body + " out.writeFByteArr( $" + (j + 1) + ");";
                                    continue;
                                }
                                if (parameterType == CtClass.charType) {
                                    body = body + " out.writeFCharArr( $" + (j + 1) + ");";
                                    continue;
                                }
                                if (parameterType == CtClass.shortType) {
                                    body = body + " out.writeFShortArr( $" + (j + 1) + ");";
                                    continue;
                                }
                                if (parameterType == CtClass.intType) {
                                    body = body + " out.writeFIntArr( $" + (j + 1) + ");";
                                    continue;
                                }
                                if (parameterType == CtClass.longType) {
                                    body = body + " out.writeFLongArr( $" + (j + 1) + ");";
                                    continue;
                                }
                                if (parameterType == CtClass.floatType) {
                                    body = body + " out.writeFFloatArr( $" + (j + 1) + ");";
                                    continue;
                                }
                                if (parameterType == CtClass.doubleType) {
                                    body = body + " out.writeFDoubleArr( $" + (j + 1) + ");";
                                    continue;
                                }
                                throw new RuntimeException("this should not happen. in trouble with method:" + method.getName());
                            }
                            if (parameterType == CtClass.booleanType) {
                                body = body + " out.writeBoolean( $" + (j + 1) + ");";
                                continue;
                            }
                            if (parameterType == CtClass.byteType) {
                                body = body + " out.writeFByte( $" + (j + 1) + ");";
                                continue;
                            }
                            if (parameterType == CtClass.charType) {
                                body = body + " out.writeFChar( $" + (j + 1) + ");";
                                continue;
                            }
                            if (parameterType == CtClass.shortType) {
                                body = body + " out.writeFShort( $" + (j + 1) + ");";
                                continue;
                            }
                            if (parameterType == CtClass.intType) {
                                body = body + " out.writeFInt( $" + (j + 1) + ");";
                                continue;
                            }
                            if (parameterType == CtClass.longType) {
                                body = body + " out.writeFLong( $" + (j + 1) + ");";
                                continue;
                            }
                            if (parameterType == CtClass.floatType) {
                                body = body + " out.writeFFloat( $" + (j + 1) + ");";
                                continue;
                            }
                            if (parameterType == CtClass.doubleType) {
                                body = body + " out.writeFDouble( $" + (j + 1) + ");";
                                continue;
                            }
                            if (!parameterType.getName().equals(String.class.getName())) continue;
                            body = body + " out.writeStringUTFSpeed( $" + (j + 1) + ");";
                        }
                        body = body + " marshaller.finishFastCall( sender, out ); }";
                        method.setBody(body);
                        this.generateCallerClass(orig, method, parameterTypes, methodIndex, originalMethod.getDeclaringClass());
                    } else {
                        remotecall = "{ if (sender==null) sender=topic.getSender(); marshaller.callRemoteMethod( topic, sender," + methodIndex + ", $args, " + (loopback != null) + ", " + (unreliable != null) + " ); }";
                        method.setBody(remotecall);
                    }
                    cc.addMethod(method);
                    continue;
                }
                if (originalMethod.getAnnotation(RemoteHelper.class) == null) {
                    method.setBody("throw new RuntimeException(\"not a remote method, method must be public void method with Annotation 'RemoteMethod'\");");
                    cc.addMethod(method);
                }
                if (remote == null) continue;
                throw new RuntimeException("@RemoteMethods have to be public void(..args). FCFutureResultHandler has to be last argument in case");
            }
            if (remote == null) continue;
            throw new RuntimeException("@RemoteMethods have to be public void(..args). FCFutureResultHandler has to be last argument in case");
        }
        return hasResultCalls;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void generateCallerClass(CtClass callTarget, CtMethod method, CtClass[] parameterTypes, int methodindex, CtClass declaringClass) {
        String key = callTarget.getName() + "#" + methodindex;
        if (generatedCallerClasses.get(key) != null) {
            return;
        }
        try {
            ClassPool pool = ClassPool.getDefault();
            CtClass cc = null;
            cc = pool.makeClass(callTarget.getName() + "_" + methodindex);
            cc.setInterfaces(new CtClass[]{pool.get(FCInvoker.class.getName())});
            CtClass invoker = pool.get(FCInvoker.class.getName());
            CtMethod[] methods = invoker.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                CtMethod ctMethod = methods[i];
                if (!ctMethod.getName().equals("invoke")) continue;
                ctMethod = new CtMethod(ctMethod, cc, null);
                String body = "{ " + FSTObjectInput.class.getName() + " out = $2;" + "((" + declaringClass.getName() + ")$1)." + method.getName() + "(";
                for (int j = 0; j < parameterTypes.length; ++j) {
                    CtClass parameterType = parameterTypes[j];
                    if (parameterType.isArray()) {
                        if ((parameterType = parameterType.getComponentType()) == CtClass.booleanType) {
                            body = body + " (boolean[]) out.readFPrimitiveArray( boolean.class, out.readFInt()) ";
                        } else if (parameterType == CtClass.byteType) {
                            body = body + " (byte[]) out.readFPrimitiveArray( byte.class, out.readFInt()) ";
                        } else if (parameterType == CtClass.charType) {
                            body = body + " (char[]) out.readFPrimitiveArray( char.class, out.readFInt()) ";
                        } else if (parameterType == CtClass.shortType) {
                            body = body + " (short[]) out.readFPrimitiveArray( short.class, out.readFInt()) ";
                        } else if (parameterType == CtClass.intType) {
                            body = body + " (int[]) out.readFPrimitiveArray( int.class, out.readFInt()) ";
                        } else if (parameterType == CtClass.longType) {
                            body = body + " (long[]) out.readFPrimitiveArray( long.class, out.readFInt()) ";
                        } else if (parameterType == CtClass.floatType) {
                            body = body + " (float[]) out.readFPrimitiveArray( float.class, out.readFInt()) ";
                        } else {
                            if (parameterType != CtClass.doubleType) throw new RuntimeException("oops, this is a bug. in trouble with method " + method.getName());
                            body = body + " (double[]) out.readFPrimitiveArray( double.class, out.readFInt()) ";
                        }
                    } else if (parameterType == CtClass.booleanType) {
                        body = body + " out.readBoolean()";
                    } else if (parameterType == CtClass.byteType) {
                        body = body + " out.readFByte()";
                    } else if (parameterType == CtClass.charType) {
                        body = body + " out.readFChar()";
                    } else if (parameterType == CtClass.shortType) {
                        body = body + " out.readFShort()";
                    } else if (parameterType == CtClass.intType) {
                        body = body + " out.readFInt()";
                    } else if (parameterType == CtClass.longType) {
                        body = body + " out.readFLong()";
                    } else if (parameterType == CtClass.floatType) {
                        body = body + " out.readFFloat()";
                    } else if (parameterType == CtClass.doubleType) {
                        body = body + " out.readFDouble()";
                    } else if (parameterType.getName().equals(String.class.getName())) {
                        body = body + " out.readStringUTFSpeed()";
                    }
                    if (j == parameterTypes.length - 1) continue;
                    body = body + ",";
                }
                body = body + "); }";
                ctMethod.setBody(body);
                cc.addMethod(ctMethod);
            }
            Class ccClz = this.loadProxyClass(FCInvoker.class, pool, cc);
            generatedCallerClasses.put(key, (FCInvoker)ccClz.newInstance());
            return;
        }
        catch (Exception e) {
            FCLog.log(e);
        }
    }

    protected boolean isFastCall(CtMethod m) throws NotFoundException {
        CtClass[] parameterTypes = m.getParameterTypes();
        if (parameterTypes == null || parameterTypes.length == 0) {
            return true;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            boolean isPrimArray;
            CtClass parameterType = parameterTypes[i];
            boolean bl = isPrimArray = parameterType.isArray() && parameterType.getComponentType().isPrimitive();
            if (isPrimArray || parameterType.isPrimitive() || parameterType.getName().equals(String.class.getName())) continue;
            return false;
        }
        return true;
    }

    protected boolean isRemoteResultCall(CtMethod m) throws NotFoundException {
        CtClass[] parameterTypes = m.getParameterTypes();
        if (parameterTypes == null || parameterTypes.length == 0) {
            return false;
        }
        String name = parameterTypes[parameterTypes.length - 1].getName();
        String name1 = FCFutureResultHandler.class.getName();
        return name.equals(name1);
    }

    protected void defineFCRemoteObjectMethods(ClassPool pool, CtClass cc, String serviceClazz, boolean hasRemoteResults) throws CannotCompileException, NotFoundException {
        CtClass proxy = pool.getCtClass(FCRemoteServiceProxy.class.getName());
        CtMethod[] methods = proxy.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            CtMethod method = methods[i];
            if ((method = new CtMethod(method, cc, null)).getName().equals("getServiceClass")) {
                method.setBody("{ return \"" + serviceClazz + "\"; }");
                cc.addMethod(method);
            }
            if (!method.getName().equals("hasCallResultMethods")) continue;
            method.setBody("{ return " + hasRemoteResults + "; }");
            cc.addMethod(method);
        }
    }

    public String toString(Method m) {
        try {
            StringBuilder sb = new StringBuilder();
            int mod = m.getModifiers() & java.lang.reflect.Modifier.methodModifiers();
            if (mod != 0) {
                sb.append(java.lang.reflect.Modifier.toString(mod)).append(' ');
            }
            sb.append(m.getReturnType()).append(' ');
            sb.append(m.getName()).append('(');
            Class<?>[] params = m.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(params[j].toString());
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public String toString(CtMethod m) {
        try {
            StringBuilder sb = new StringBuilder();
            int mod = m.getModifiers() & java.lang.reflect.Modifier.methodModifiers();
            if (mod != 0) {
                sb.append(java.lang.reflect.Modifier.toString(mod)).append(' ');
            }
            sb.append(m.getReturnType().getName()).append(' ');
            sb.append(m.getName()).append('(');
            CtClass[] params = m.getParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                sb.append(params[j].getName());
                if (j >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public Method[] getSortedPublicMethods(Class orig) {
        Method method;
        int i;
        int count = 0;
        Method[] methods0 = orig.getMethods();
        HashSet<String> alreadypresent = new HashSet<String>();
        for (int i2 = 0; i2 < methods0.length; ++i2) {
            Method method2 = methods0[i2];
            String str = this.toString(method2);
            if (alreadypresent.contains(str)) {
                methods0[i2] = null;
                continue;
            }
            alreadypresent.add(str);
        }
        HashSet<Byte> ids = new HashSet<Byte>();
        for (i = 0; i < methods0.length; ++i) {
            method = methods0[i];
            RemoteMethod annotation = method.getAnnotation(RemoteMethod.class);
            if (method != null && annotation != null && !Modifier.isPublic((int)method.getModifiers())) {
                throw new RuntimeException("Remote methods must be public:" + method.getName());
            }
            if (annotation == null) continue;
            if (ids.contains(annotation.value())) {
                throw new RuntimeException("double remote method id method '" + method.getName() + "' " + annotation.value());
            }
            if (annotation.value() < 1 && !method.getName().equals("receiveBinary")) {
                throw new RuntimeException("remote method id must be > 0" + method);
            }
            ids.add(annotation.value());
        }
        count = 0;
        for (i = 0; i < methods0.length; ++i) {
            method = methods0[i];
            if (method == null || method.getAnnotation(RemoteMethod.class) == null || !Modifier.isPublic((int)method.getModifiers())) continue;
            ++count;
        }
        Method[] methods = new Method[count];
        count = 0;
        for (int i3 = 0; i3 < methods0.length; ++i3) {
            Method method3 = methods0[i3];
            if (method3 == null || method3.getAnnotation(RemoteMethod.class) == null || !Modifier.isPublic((int)method3.getModifiers())) continue;
            methods[count++] = method3;
        }
        if (orig.isInterface()) {
            Method[] objM = Object.class.getMethods();
            Method[] res = new Method[objM.length + methods.length];
            System.arraycopy(methods, 0, res, 0, methods.length);
            System.arraycopy(objM, 0, res, methods.length, objM.length);
            methods = res;
        }
        Arrays.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return (o1.getName() + o1.getReturnType() + o1.getParameterTypes().length).compareTo(o2.getName() + o2.getReturnType() + o2.getParameterTypes().length);
            }
        });
        return methods;
    }

    protected CtMethod[] getSortedPublicCtMethods(CtClass orig, boolean onlyRemote) {
        CtMethod method;
        int count = 0;
        CtMethod[] methods0 = orig.getMethods();
        HashSet<String> alreadypresent = new HashSet<String>();
        for (int i = methods0.length - 1; i >= 0; --i) {
            CtMethod method2 = methods0[i];
            String str = this.toString(method2);
            if (alreadypresent.contains(str)) {
                methods0[i] = null;
                continue;
            }
            alreadypresent.add(str);
        }
        CtMethod[] methods = null;
        if (onlyRemote) {
            boolean isRemote;
            int i;
            for (i = 0; i < methods0.length; ++i) {
                try {
                    method = methods0[i];
                    if (method == null) continue;
                    boolean bl = isRemote = method.getAnnotation(RemoteMethod.class) != null;
                    if (isRemote && (method.getModifiers() & 1) != 0) {
                        ++count;
                        continue;
                    }
                    if (!isRemote) continue;
                    throw new RuntimeException("@RemoteMethod's must be 'public void'");
                }
                catch (ClassNotFoundException e) {
                    FCLog.log(e);
                }
            }
            methods = new CtMethod[count];
            count = 0;
            for (i = 0; i < methods0.length; ++i) {
                try {
                    method = methods0[i];
                    boolean bl = isRemote = method.getAnnotation(RemoteMethod.class) != null;
                    if (!isRemote || (method.getModifiers() & 1) == 0) continue;
                    methods[count++] = method;
                    continue;
                }
                catch (ClassNotFoundException e) {
                    FCLog.log(e);
                }
            }
        } else {
            int i;
            count = 0;
            for (i = 0; i < methods0.length; ++i) {
                method = methods0[i];
                if (method == null) continue;
                ++count;
            }
            methods = new CtMethod[count];
            count = 0;
            for (i = 0; i < methods0.length; ++i) {
                method = methods0[i];
                if (method == null) continue;
                methods[count++] = method;
            }
        }
        Arrays.sort(methods, new Comparator<CtMethod>(){

            @Override
            public int compare(CtMethod o1, CtMethod o2) {
                try {
                    return (o1.getName() + o1.getReturnType() + o1.getParameterTypes().length).compareTo(o2.getName() + o2.getReturnType() + o2.getParameterTypes().length);
                }
                catch (NotFoundException e) {
                    FCLog.log(e);
                    return 0;
                }
            }
        });
        return methods;
    }
}

