/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.packeting;

import java.io.Serializable;

public class TopicStats
implements Serializable {
    int packetsSent;
    int packetsReceived;
    int msgSent;
    int msgReceived;
    int retransRQSent;
    int retransRSPSent;
    int retransRQReceived;
    long recordStart;
    int lastSendPause;
    volatile transient TopicStats snapshot;
    long recordEnd;
    private double retransReq;
    private int dgramSiz;
    private long sendBytes;
    private long bytesReceived;

    public TopicStats(int dgramSiz) {
        this.recordStart = System.currentTimeMillis();
        this.dgramSiz = dgramSiz;
    }

    public TopicStats(long bytesReceived, long sendBytes, int packetsSent, int packetsReceived, int msgSent, int msgReceived, int retransRQSent, int retransRSPSent, long recordStart, int rqRec, int dgramSiz) {
        this.packetsSent = packetsSent;
        this.sendBytes = sendBytes;
        this.packetsReceived = packetsReceived;
        this.msgSent = msgSent;
        this.bytesReceived = bytesReceived;
        this.msgReceived = msgReceived;
        this.retransRQSent = retransRQSent;
        this.retransRSPSent = retransRSPSent;
        this.recordStart = recordStart;
        this.retransRQReceived = rqRec;
        this.dgramSiz = dgramSiz;
    }

    public TopicStats snapshot() {
        return new TopicStats(this.bytesReceived, this.sendBytes, this.packetsSent, this.packetsReceived, this.msgSent, this.msgReceived, this.retransRQSent, this.retransRSPSent, this.recordStart, this.retransRQReceived, this.dgramSiz);
    }

    public double getMsgReceivedPerPacket() {
        if (this.packetsReceived == 0) {
            return 0.0;
        }
        return (double)this.msgReceived / (double)this.packetsReceived;
    }

    public double getMsgReceived() {
        long dur = this.recordEnd - this.recordStart;
        if (dur == 0L) {
            return 0.0;
        }
        return (double)this.msgReceived * 1000.0 / (double)dur;
    }

    public double getMsgSentPerPacket() {
        if (this.packetsSent == 0) {
            return 0.0;
        }
        return (double)this.msgSent / (double)this.packetsSent;
    }

    public double getPacketsSentPerSecond() {
        return this.getPacketsSentPerSecond(this.recordEnd);
    }

    public long getBytesSentPerSecond() {
        return this.getBytesSentPerSecond(this.recordEnd);
    }

    public long getBytesRecPerSecond() {
        return this.getBytesRecPerSecond(this.recordEnd);
    }

    public long getBytesSentPerSecond(long millis) {
        long dur = millis - this.recordStart;
        if (dur == 0L) {
            return 0L;
        }
        return this.sendBytes * 1000L / dur;
    }

    public long getBytesRecPerSecond(long millis) {
        long dur = millis - this.recordStart;
        if (dur == 0L) {
            return 0L;
        }
        return this.bytesReceived * 1000L / dur;
    }

    public double getPacketsSentPerSecond(long nowMillis) {
        long dur = nowMillis - this.recordStart;
        if (dur == 0L) {
            return 0.0;
        }
        return (double)this.packetsSent * 1000.0 / (double)dur;
    }

    public double getPacketsRetransSentPerSecond() {
        return this.getPacketsRetransSentPerSecond(this.recordEnd);
    }

    public double getPacketsRetransSentPerSecond(long nowMillis) {
        long dur = nowMillis - this.recordStart;
        if (dur == 0L) {
            return 0.0;
        }
        return (double)this.retransRSPSent * 1000.0 / (double)dur;
    }

    public double getRetransReq() {
        long dur = this.recordEnd - this.recordStart;
        if (dur == 0L) {
            return 0.0;
        }
        return (double)this.retransRQSent * 1000.0 / (double)dur;
    }

    public double getMsgSent() {
        long dur = this.recordEnd - this.recordStart;
        if (dur == 0L) {
            return 0.0;
        }
        return (double)this.msgSent * 1000.0 / (double)dur;
    }

    public double getPacketsRecPerSecond() {
        return this.getPacketsRecPerSecond(this.recordEnd);
    }

    public double getPacketsRecPerSecond(long nowMillis) {
        long dur = nowMillis - this.recordStart;
        if (dur == 0L) {
            return 0.0;
        }
        return (double)this.packetsReceived * 1000.0 / (double)dur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        TopicStats topicStats = this;
        synchronized (topicStats) {
            long now = System.currentTimeMillis();
            if (now - this.recordStart < 1000L) {
                return;
            }
            this.snapshot = this.snapshot();
            this.snapshot.recordEnd = now;
            this.snapshot.lastSendPause = this.lastSendPause;
            this.snapshot.snapshot = null;
            this.packetsSent = 0;
            this.sendBytes = 0L;
            this.bytesReceived = 0L;
            this.packetsReceived = 0;
            this.msgSent = 0;
            this.msgReceived = 0;
            this.retransRQSent = 0;
            this.retransRSPSent = 0;
            this.retransRQReceived = 0;
            this.recordStart = now;
        }
    }

    public TopicStats getSnapshot() {
        return this.snapshot;
    }

    public void addTo(TopicStats other, int divisor) {
        other.packetsSent = (this.packetsSent + other.packetsSent * (divisor - 1)) / divisor;
        other.sendBytes = (this.sendBytes + other.sendBytes * (long)(divisor - 1)) / (long)divisor;
        other.bytesReceived = (this.bytesReceived + other.bytesReceived * (long)(divisor - 1)) / (long)divisor;
        other.packetsReceived = (this.packetsReceived + other.packetsReceived * (divisor - 1)) / divisor;
        other.msgSent = (this.msgSent + other.msgSent * (divisor - 1)) / divisor;
        other.msgReceived = (this.msgReceived + other.msgReceived * (divisor - 1)) / divisor;
        other.retransRQSent = (this.retransRQSent + other.retransRQSent * (divisor - 1)) / divisor;
        other.retransRQReceived = (this.retransRQReceived + other.retransRQReceived * (divisor - 1)) / divisor;
        other.retransRSPSent = (this.retransRSPSent + other.retransRSPSent * (divisor - 1)) / divisor;
    }

    public long getRecordStart() {
        return this.recordStart;
    }

    public long getRecordEnd() {
        return this.recordEnd;
    }

    public void dataPacketSent(int size) {
        ++this.packetsSent;
        this.sendBytes += (long)size;
    }

    public void dataPacketReceived(int size) {
        ++this.packetsReceived;
        this.bytesReceived += (long)size;
    }

    public double getRetransVSDataPacketPercentage() {
        if (this.packetsSent < 1) {
            return 0.0;
        }
        return (double)this.retransRQReceived / (double)this.packetsSent;
    }

    public int getLastSendPause() {
        return this.lastSendPause;
    }

    public void setLastSendPause(int lastSendPauseUncorrected) {
        this.lastSendPause = lastSendPauseUncorrected;
    }

    public void msgSent() {
        ++this.msgSent;
    }

    public void msgReceived() {
        ++this.msgReceived;
    }

    public void retransRQSent(int num) {
        this.retransRQSent += num;
    }

    public void retransRQReceived(int num, int myRate) {
        this.retransRQReceived += num;
    }

    public void retransRSPSent(int num, int size) {
        this.retransRSPSent += num;
    }

    public String toString() {
        long now = this.recordEnd == 0L ? System.currentTimeMillis() : this.recordEnd;
        return "TopicStats{\n  packetsSent=" + this.packetsSent + "\n" + "  packetsReceived=" + this.packetsReceived + "\n" + "  msgSent=" + this.msgSent + "\n" + "  msgReceived=" + this.msgReceived + "\n" + "  retransRespSent=" + this.retransRSPSent + "\n" + "  retransRQSent=" + this.retransRQSent + "\n" + "  retransRQRec=" + this.retransRQReceived + "\n" + "  ---------------" + "\n" + "  msgRec/Pack =" + this.getMsgReceivedPerPacket() + "\n" + "  msgSent/Pack=" + this.getMsgSentPerPacket() + "\n" + "  packRec/s   =" + this.getPacketsRecPerSecond(now) + "\n" + "  packSent/s  =" + this.getPacketsSentPerSecond(now) + "\n" + "  retransPerc =" + this.getRetransVSDataPacketPercentage() + "\n" + "  flow pause  =" + this.lastSendPause + "\n" + '}';
    }

    public int getDgramSize() {
        return this.dgramSiz;
    }
}

