/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.packeting;

import de.ruedigermoeller.fastcast.config.FCTopicConf;
import de.ruedigermoeller.fastcast.control.FCTransportDispatcher;
import de.ruedigermoeller.fastcast.control.FlowControl;
import de.ruedigermoeller.fastcast.packeting.MsgReceiver;
import de.ruedigermoeller.fastcast.packeting.PacketSendBuffer;
import de.ruedigermoeller.fastcast.packeting.TopicStats;
import de.ruedigermoeller.fastcast.remoting.FCCallbackMap;
import de.ruedigermoeller.fastcast.remoting.FCInvoker;
import de.ruedigermoeller.fastcast.remoting.FCRemoteServiceProxy;
import de.ruedigermoeller.fastcast.remoting.FCTopicService;
import de.ruedigermoeller.fastcast.remoting.FastCast;
import de.ruedigermoeller.fastcast.remoting.RemoteMethod;
import de.ruedigermoeller.fastcast.remoting.Unordered;
import de.ruedigermoeller.fastcast.remoting.Unreliable;
import de.ruedigermoeller.fastcast.transport.Transport;
import de.ruedigermoeller.fastcast.util.FCLog;
import de.ruedigermoeller.fastcast.util.FCUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class TopicEntry {
    FCTopicConf conf;
    FCTransportDispatcher channelDispatcher;
    String serviceClazz;
    FCTopicService service;
    FCRemoteServiceProxy serviceProxy;
    Method[] methods;
    Class[][] methodArgs;
    FCCallbackMap cbMap;
    PacketSendBuffer sender;
    TopicStats stats;
    Transport trans;
    FlowControl control;
    ConcurrentHashMap<String, Long> senderHeartbeat = new ConcurrentHashMap();
    Executor replys;
    ExecutorService methodExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread res = new Thread(r);
            res.setName("Loopback calls");
            return res;
        }
    });
    boolean isUnordered = false;
    boolean isUnreliable = false;
    volatile boolean listenCalls = false;
    FCInvoker[] methodInvoker;
    private MsgReceiver msgReceiver;

    public TopicEntry(FCTopicConf conf) {
        this.conf = conf;
        if (conf.getFlowControlClass() != null) {
            try {
                this.control = (FlowControl)Class.forName(conf.getFlowControlClass()).newInstance();
            }
            catch (Exception e) {
                FCLog.log(e);
            }
        }
        this.replys = FCUtils.createBoundedSingleThreadExecutor("reply-" + this.getConf().getName(), conf.getMaxOpenRespondedCalls());
    }

    public Executor getReplys() {
        return this.replys;
    }

    public boolean hasRemoteResultCalls() {
        if (this.getServiceProxy() == null) {
            throw new RuntimeException("no service class for this topic specified.");
        }
        return this.getServiceProxy().hasCallResultMethods();
    }

    public boolean isListenCalls() {
        return this.listenCalls;
    }

    public void setListenCalls(boolean listenCalls) {
        this.listenCalls = listenCalls;
    }

    public void registerHeartBeat(String sender, long time) {
        this.senderHeartbeat.put(sender, time);
    }

    public boolean hadHeartbeat(String sender) {
        return this.senderHeartbeat.containsKey(sender);
    }

    public List<String> getTimedOutSenders(long now, long timeout) {
        ArrayList<String> res = new ArrayList<String>();
        for (String next : this.senderHeartbeat.keySet()) {
            long tim = this.senderHeartbeat.get(next);
            if (now - tim <= timeout) continue;
            res.add(next);
        }
        return res;
    }

    public FlowControl getControl() {
        return this.control;
    }

    public void setControl(FlowControl control) {
        this.control = control;
    }

    public FCTopicConf getConf() {
        return this.conf;
    }

    public Transport getTrans() {
        return this.trans;
    }

    public void setTrans(Transport trans) {
        this.trans = trans;
        this.stats = new TopicStats(trans.getConf().getDgramsize());
    }

    public ExecutorService getMethodExecutor() {
        return this.methodExecutor;
    }

    public void setConf(FCTopicConf conf) {
        this.conf = conf;
    }

    public FCCallbackMap getCbMap() {
        if (this.cbMap == null) {
            this.cbMap = new FCCallbackMap(this.conf.getMaxOpenRespondedCalls(), this.conf.getResponseMethodsTimeout());
        }
        return this.cbMap;
    }

    void setCbMap(FCCallbackMap cbMap) {
        this.cbMap = cbMap;
    }

    public boolean isUnordered() {
        return this.isUnordered;
    }

    public FCTransportDispatcher getChannelDispatcher() {
        return this.channelDispatcher;
    }

    public void setChannelDispatcher(FCTransportDispatcher channelDispatcher) {
        this.channelDispatcher = channelDispatcher;
    }

    public String getServiceClazz() {
        return this.conf.getServiceClass();
    }

    public FCTopicService getService() {
        return this.service;
    }

    public void setService(FCTopicService service) {
        this.isUnordered = service.getClass().getAnnotation(Unordered.class) != null;
        this.isUnreliable = service.getClass().getAnnotation(Unreliable.class) != null;
        this.service = service;
    }

    public boolean isUnreliable() {
        return this.isUnreliable;
    }

    public void setUnreliable(boolean unreliable) {
        this.isUnreliable = unreliable;
    }

    public FCRemoteServiceProxy getServiceProxy() {
        return this.serviceProxy;
    }

    public void setServiceProxy(FCRemoteServiceProxy serviceProxy) {
        this.serviceProxy = serviceProxy;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public void setSender(PacketSendBuffer sender) {
        this.sender = sender;
    }

    public Class[][] getMethodArgs() {
        return this.methodArgs;
    }

    public FCInvoker[] getMethodInvoker() {
        return this.methodInvoker;
    }

    public void setMethods(Method[] methods) {
        this.methods = new Method[128];
        this.methodArgs = new Class[this.methods.length][];
        this.methodInvoker = new FCInvoker[this.methods.length];
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            byte index = method.getAnnotation(RemoteMethod.class).value();
            if (index <= -1) continue;
            this.methodArgs[index] = method.getParameterTypes();
            this.methods[index] = method;
        }
    }

    public PacketSendBuffer getSender() {
        return this.sender;
    }

    public int getTopic() {
        return this.conf.getTopic();
    }

    public TopicStats getStats() {
        if (this.stats == null) {
            this.stats = new TopicStats(((FastCast)FastCast.getRemoting()).getTransport(this.getConf().getTransport()).getConf().getDgramsize());
        }
        return this.stats;
    }

    public void setMsgReceiver(MsgReceiver msgReceiver) {
        if (this.msgReceiver != null) {
            throw new RuntimeException("Only one msg recevier per topic allowed " + this.getConf().getName());
        }
        this.msgReceiver = msgReceiver;
    }

    public MsgReceiver getMsgReceiver() {
        return this.msgReceiver;
    }

    public void removeSenders(List<String> timedOutSenders) {
        for (String s : timedOutSenders) {
            this.senderHeartbeat.remove(s);
        }
    }

    public String getName() {
        return this.getConf().getName();
    }
}

