/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.packeting;

import de.ruedigermoeller.fastcast.packeting.Packet;
import de.ruedigermoeller.heapoff.structs.FSTStruct;
import de.ruedigermoeller.heapoff.structs.FSTStructAllocator;

public class DataPacket
extends Packet {
    public static final short COMPLETE = 1;
    public static final short CHAINED = 2;
    public static final short EOP = 3;
    public static final short MAX_CODE = 3;
    public static final int HEADERLEN = 4;
    protected volatile boolean isDecoded;
    protected int bytesLeft;
    protected byte[] data = new byte[0];

    public static DataPacket getTemplate(int packetSize) {
        int emptyPackSize = ((DataPacket)new FSTStructAllocator(1).newStruct((FSTStruct)new DataPacket())).getByteSize();
        DataPacket template = new DataPacket();
        int payMaxLen = packetSize - emptyPackSize - 2;
        template.data = new byte[payMaxLen];
        return template;
    }

    public void data(int index, byte val) {
        this.data[index] = val;
    }

    public byte data(int index) {
        return this.data[index];
    }

    public int dataLen() {
        return this.data.length;
    }

    public int dataIndex() {
        return -1;
    }

    public boolean isDecoded() {
        return this.isDecoded;
    }

    public void setDecoded(boolean decoded) {
        this.isDecoded = decoded;
    }

    public void dataPointer(FSTStruct pointer) {
    }

    public FSTStruct dataPointer() {
        return null;
    }

    public int getBytesLeft() {
        return this.bytesLeft;
    }

    public int getDGramSize() {
        return this.getByteSize() - this.bytesLeft;
    }

    public void setBytesLeft(int bytesLeft) {
        this.bytesLeft = bytesLeft;
    }

    public void dumpBytes() {
        for (int n = 0; n < this.dataLen() - this.getBytesLeft(); ++n) {
            System.out.print(" [" + n + "], " + this.data(n));
        }
        System.out.println("-");
    }

    @Override
    public String toString() {
        return "DataPacket{sent=" + this.sent + ", seqNo=" + this.seqNo + ", topic=" + this.topic + ", sender=" + this.sender + ", receiver=" + this.receiver + ", cluster=" + this.cluster + ", left=" + this.bytesLeft + ", datalen=" + this.dataLen() + ", dgsize=" + this.getDGramSize() + ", decoded=" + this.isDecoded() + '}';
    }
}

