/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.fastcast.config;

public class FCTopicConf {
    String name;
    String transport = "default";
    int topic;
    String serviceClass;
    int maxOpenRespondedCalls = 10000;
    int responseMethodsTimeout = 3000;
    int numPacketHistory = 5000;
    int maxSendPacketQueueSize = 100;
    int receiveBufferPackets = 1000;
    int sendPauseMicros = -1;
    long senderTimeoutMillis = 10000L;
    long heartbeatInterval = 200L;
    long flowControlInterval = 1000L;
    long maxDelayRetransMS = 1L;
    long maxDelayNextRetransMS = 5L;
    boolean perSenderThread = false;
    boolean decodeInTransportThread = false;
    boolean optForLatency = false;
    boolean useSpinlockInSendQueue = false;
    String flowControlClass = null;
    int decodeQSize = 10000;
    boolean autoStart = false;
    private int dGramRate;

    public FCTopicConf() {
    }

    public FCTopicConf(String name, String transport, int topic, String serviceClass) {
        this.name = name;
        this.transport = transport;
        this.topic = topic;
        this.serviceClass = serviceClass;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public String getFlowControlClass() {
        return this.flowControlClass;
    }

    public void setFlowControlClass(String flowControlClass) {
        this.flowControlClass = flowControlClass;
    }

    public boolean isPerSenderThread() {
        return this.perSenderThread;
    }

    public void setPerSenderThread(boolean perSenderThread) {
        this.perSenderThread = perSenderThread;
    }

    public boolean isOptForLatency() {
        return this.optForLatency;
    }

    public void setOptForLatency(boolean optForLatency) {
        this.optForLatency = optForLatency;
    }

    public boolean isDecodeInTransportThread() {
        return this.decodeInTransportThread;
    }

    public void setDecodeInTransportThread(boolean decodeInTransportThread) {
        this.decodeInTransportThread = decodeInTransportThread;
    }

    public int getNumPacketHistory() {
        return this.numPacketHistory;
    }

    public void setNumPacketHistory(int numPacketHistory) {
        this.numPacketHistory = numPacketHistory;
    }

    public FCTopicConf(String name) {
        this.name = name;
    }

    public int getResponseMethodsTimeout() {
        return this.responseMethodsTimeout;
    }

    public void setResponseMethodsTimeout(int responseMethodsTimeout) {
        this.responseMethodsTimeout = responseMethodsTimeout;
    }

    public int getMaxOpenRespondedCalls() {
        return this.maxOpenRespondedCalls;
    }

    public void setMaxOpenRespondedCalls(int maxOpenRespondedCalls) {
        this.maxOpenRespondedCalls = maxOpenRespondedCalls;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTransport() {
        return this.transport;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public int getTopic() {
        return this.topic;
    }

    public void setTopic(int topic) {
        this.topic = topic;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public int getReceiveBufferPackets() {
        return this.receiveBufferPackets;
    }

    public void setReceiveBufferPackets(int receiveBufferPackets) {
        this.receiveBufferPackets = receiveBufferPackets;
    }

    public int getSendPauseMicros() {
        return this.sendPauseMicros == -1 ? 300 : this.sendPauseMicros;
    }

    public int getMaxSendPacketQueueSize() {
        return this.maxSendPacketQueueSize;
    }

    public void setMaxSendPacketQueueSize(int maxSendPacketQueueSize) {
        this.maxSendPacketQueueSize = maxSendPacketQueueSize;
    }

    public long getMaxDelayRetransMS() {
        return this.maxDelayRetransMS;
    }

    public void setMaxDelayRetransMS(long maxDelyRetransMS) {
        this.maxDelayRetransMS = maxDelyRetransMS;
    }

    public long getMaxDelayNextRetransMS() {
        return this.maxDelayNextRetransMS;
    }

    public void setMaxDelayNextRetransMS(long maxDelayNextRetransMS) {
        this.maxDelayNextRetransMS = maxDelayNextRetransMS;
    }

    public boolean useSpinlockInSendQueue() {
        return this.useSpinlockInSendQueue;
    }

    public void setUseSpinlockInSendQueue(boolean useSpinlockInSendQueue) {
        this.useSpinlockInSendQueue = useSpinlockInSendQueue;
    }

    public int getDecodeQSize() {
        return this.decodeQSize;
    }

    public void setDecodeQSize(int decodeQSize) {
        this.decodeQSize = decodeQSize;
    }

    public long getSenderTimeoutMillis() {
        return this.senderTimeoutMillis;
    }

    public void setSenderTimeoutMillis(long senderTimeoutMillis) {
        this.senderTimeoutMillis = senderTimeoutMillis;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public long getFlowControlInterval() {
        return this.flowControlInterval;
    }

    public void setFlowControlInterval(long flowControlInterval) {
        this.flowControlInterval = flowControlInterval;
    }

    public void setDGramRate(int DGramRate) {
        if (DGramRate == 0) {
            return;
        }
        int slowdown = 1000000 / DGramRate;
        if (slowdown < 1) {
            slowdown = 1;
        }
        this.sendPauseMicros = slowdown;
        this.dGramRate = DGramRate;
    }

    public int getDGramRate() {
        return this.dGramRate;
    }
}

