/*
 * Decompiled with CFR 0.152.
 */
package de.richtercloud.equals.lambda;

import de.richtercloud.equals.lambda.EqualsCheck;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EqualsLambda {
    public static <T> boolean equals(T a, T b, EqualsCheck<T> equalsCheck) {
        if (equalsCheck == null) {
            throw new IllegalArgumentException("equalsCheck mustn't be null");
        }
        return a == b || a != null && equalsCheck.equals(a, b);
    }

    public static <T> boolean equalsSet(Set<T> a, Set<T> b, EqualsCheck<T> equalsCheck) {
        if (equalsCheck == null) {
            throw new IllegalArgumentException("equalsCheck mustn't be null");
        }
        if (a == b) {
            return true;
        }
        if (a.stream().anyMatch(a0 -> b.stream().noneMatch(b0 -> equalsCheck.equals(a0, b0)))) {
            return false;
        }
        return !b.stream().anyMatch(b0 -> a.stream().noneMatch(a0 -> equalsCheck.equals(b0, a0)));
    }

    public static <T> boolean equalsList(List<T> a, List<T> b, EqualsCheck<T> equalsCheck) {
        if (equalsCheck == null) {
            throw new IllegalArgumentException("equalsCheck mustn't be null");
        }
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        Iterator<T> aItr = a.iterator();
        Iterator<T> bItr = b.iterator();
        while (aItr.hasNext()) {
            T bNxt;
            T aNxt = aItr.next();
            if (equalsCheck.equals(aNxt, bNxt = bItr.next())) continue;
            return false;
        }
        return true;
    }

    public static <K, V> boolean equalsMap(Map<K, V> a, Map<K, V> b, EqualsCheck<K> equalsCheckKey, EqualsCheck<V> equalsCheckValue) {
        if (equalsCheckKey == null) {
            throw new IllegalArgumentException("equalsCheckKey mustn't be null");
        }
        if (equalsCheckValue == null) {
            throw new IllegalArgumentException("equalsCheckValue mustn't be null");
        }
        if (a == b) {
            return true;
        }
        if (a.size() != b.size()) {
            return false;
        }
        if (!EqualsLambda.equalsSet(a.keySet(), b.keySet(), equalsCheckKey)) {
            return false;
        }
        for (K key : a.keySet()) {
            if (equalsCheckValue.equals(a.get(key), b.get(key))) continue;
            return false;
        }
        return true;
    }
}

