/*
 * Decompiled with CFR 0.152.
 */
package de.retest.ui.descriptors;

import de.retest.ui.descriptors.IdentifyingAttributes;
import de.retest.ui.descriptors.RetestIdProvider;
import de.retest.util.RetestIdUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class DefaultRetestIdProvider
implements RetestIdProvider {
    private final Set<String> knownRetestIds = new HashSet<String>();

    @Override
    public String getRetestId(IdentifyingAttributes identifyingAttributes) {
        if (identifyingAttributes == null) {
            throw new NullPointerException("Identifying attributes must not be null.");
        }
        String text = (String)identifyingAttributes.get("text");
        String type = (String)identifyingAttributes.get("type");
        String rawId = text != null ? text : type;
        String id = RetestIdUtil.normalizeAndCut(rawId);
        return this.makeUnique(id);
    }

    private String makeUnique(String id) {
        String uniqueId = id;
        while (this.knownRetestIds.contains(uniqueId)) {
            uniqueId = id + "-" + UUID.randomUUID().toString().substring(0, 5);
        }
        this.knownRetestIds.add(uniqueId);
        return uniqueId;
    }

    @Override
    public void reset() {
        this.knownRetestIds.clear();
    }
}

